/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.element.facet.common.GroupFacet;
import com.baselet.element.interfaces.GridElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Selector {
    private void selectHelper(boolean applyAfterAction, Collection<GridElement> elements) {
        for (GridElement e : this.expand(elements)) {
            if (this.getSelectedElements().contains(e)) continue;
            this.getSelectedElements().add(e);
            this.doAfterSelect(e);
        }
        if (applyAfterAction) {
            this.doAfterSelectionChanged();
        }
    }

    private void deselectHelper(boolean applyAfterAction, Collection<GridElement> elements) {
        for (GridElement e : this.expand(elements)) {
            Iterator<GridElement> iter = this.getSelectedElements().iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(e)) continue;
                iter.remove();
                this.doAfterDeselect(e);
            }
        }
        if (applyAfterAction) {
            this.doAfterSelectionChanged();
        }
    }

    private List<GridElement> expand(Collection<GridElement> elements) {
        Map<String, Collection<GridElement>> map = Selector.createGroupElementMap(this.getAllElements());
        ArrayList<GridElement> elemenentsWithGroups = new ArrayList<GridElement>();
        for (GridElement e : elements) {
            Collection<GridElement> set;
            String groupValue = GroupFacet.getElementGroupValSafe(e.getGroup());
            if (groupValue == null || (set = map.get(groupValue)) == null) continue;
            for (GridElement g : set) {
                if (g == e) continue;
                elemenentsWithGroups.add(g);
            }
        }
        elemenentsWithGroups.addAll(elements);
        return elemenentsWithGroups;
    }

    public void select(GridElement element) {
        this.select(Arrays.asList(element));
    }

    public void deselect(GridElement element) {
        this.deselect(Arrays.asList(element));
    }

    public abstract List<GridElement> getSelectedElements();

    public boolean isSelected(GridElement ge) {
        return this.getSelectedElements().contains(ge);
    }

    public boolean isSelectedOnly(GridElement ge) {
        return this.getSelectedElements().size() == 1 && this.isSelected(ge);
    }

    public void selectOnly(GridElement element) {
        this.selectOnly(Arrays.asList(element));
    }

    public void selectOnly(Collection<GridElement> elements) {
        this.deselectHelper(false, this.getSelectedElements());
        this.selectHelper(true, elements);
    }

    public void select(Collection<GridElement> elements) {
        this.selectHelper(true, elements);
    }

    public void deselect(Collection<GridElement> elements) {
        this.deselectHelper(true, elements);
    }

    public void deselectAll() {
        this.deselect(this.getSelectedElements());
    }

    public void deselectAllWithoutAfterAction() {
        this.deselectHelper(false, this.getSelectedElements());
    }

    public void doAfterDeselect(GridElement e) {
        e.getComponent().afterModelUpdate();
    }

    public void doAfterSelectionChanged() {
    }

    public void doAfterSelect(GridElement e) {
        e.getComponent().afterModelUpdate();
    }

    public void moveToLastPosInList(GridElement element) {
        List<GridElement> elements = this.getSelectedElements();
        elements.remove(element);
        elements.add(element);
    }

    public String getUnusedGroup() {
        return Selector.getUnusedGroupId(Selector.createGroupElementMap(this.getAllElements()).keySet());
    }

    public abstract List<GridElement> getAllElements();

    public static void replaceGroupsWithNewGroups(Collection<GridElement> elements, Selector selector) {
        HashSet<String> usedIds = new HashSet<String>(Selector.createGroupElementMap(selector.getAllElements()).keySet());
        Map<String, Collection<GridElement>> groupedElements = Selector.createGroupElementMap(elements);
        for (Map.Entry<String, Collection<GridElement>> entry : groupedElements.entrySet()) {
            String unusedId = Selector.getUnusedGroupId(usedIds);
            usedIds.add(unusedId);
            for (GridElement e : entry.getValue()) {
                e.setProperty("group", unusedId);
            }
        }
    }

    public static String getUnusedGroupId(Collection<String> usedGroups) {
        String newGroup;
        while (usedGroups.contains(newGroup = GroupFacet.nextDefaultKey())) {
        }
        return newGroup;
    }

    public static Map<String, Collection<GridElement>> createGroupElementMap(Collection<GridElement> elements) {
        HashMap<String, Collection<GridElement>> returnmap = new HashMap<String, Collection<GridElement>>();
        for (GridElement e : elements) {
            String groupValue = GroupFacet.getElementGroupValSafe(e.getGroup());
            if (groupValue == null) continue;
            ArrayList<GridElement> elementsWithGroup = (ArrayList<GridElement>)returnmap.get(groupValue);
            if (elementsWithGroup == null) {
                elementsWithGroup = new ArrayList<GridElement>();
                returnmap.put(groupValue, elementsWithGroup);
            }
            elementsWithGroup.add(e);
        }
        return returnmap;
    }
}

