/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.drawer;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;

public class Canvas {
    private int borderspace;
    private final Rectangle outerBorder;
    private final Rectangle innerBorder;
    private final Dimension gridElementSize;

    public Canvas(Dimension gridElementSize) {
        this.gridElementSize = gridElementSize;
        this.outerBorder = new Rectangle();
        this.innerBorder = new Rectangle();
        this.setBorder(0, 0, 0, 0, 0);
    }

    public void setBorder(int x, int y, int width, int height, int borderspace) {
        this.borderspace = borderspace;
        this.outerBorder.setBounds(x, y, width, height);
        this.updateInnerBorder();
    }

    public void setBorderX(int x) {
        this.outerBorder.setBounds(x, this.outerBorder.y, this.outerBorder.width, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderY(int y) {
        this.outerBorder.setBounds(this.outerBorder.x, y, this.outerBorder.width, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderWidth(int width) {
        this.outerBorder.setBounds(this.outerBorder.x, this.outerBorder.y, width, this.outerBorder.height);
        this.updateInnerBorder();
    }

    public void setBorderHeight(int height) {
        this.outerBorder.setBounds(this.outerBorder.x, this.outerBorder.y, this.outerBorder.width, height);
        this.updateInnerBorder();
    }

    private void updateInnerBorder() {
        this.innerBorder.setBounds(this.outerBorder.x + this.borderspace, this.outerBorder.y + this.borderspace, this.outerBorder.width + this.borderspace, this.outerBorder.height + this.borderspace);
    }

    public int getInnerLeftPos() {
        return this.innerBorder.x;
    }

    public int getInnerUpPos() {
        return this.innerBorder.y;
    }

    public int getInnerRightBorderWidth() {
        return this.innerBorder.width;
    }

    public int getInnerDownBorderHeight() {
        return this.innerBorder.height;
    }

    public int getInnerRightPos() {
        return this.gridElementSize.width - this.getInnerRightBorderWidth();
    }

    public int getInnerDownPos() {
        return this.gridElementSize.height - this.getInnerDownBorderHeight();
    }

    public int getInnerHorizontalSum() {
        return this.getInnerLeftPos() + this.getInnerRightBorderWidth();
    }

    public int getInnerVerticalSum() {
        return this.getInnerUpPos() + this.getInnerDownBorderHeight();
    }

    public int getInnerHorizontalDrawspace() {
        return this.getInnerRightPos() - this.getInnerLeftPos();
    }

    public int getInnerVerticalDrawspace() {
        return this.getInnerDownPos() - this.getInnerUpPos();
    }

    public int getOuterLeftPos() {
        return this.outerBorder.x;
    }

    public int getOuterUpPos() {
        return this.outerBorder.y;
    }

    public int getOuterRightBorderWidth() {
        return this.outerBorder.width;
    }

    public int getOuterDownBorderHeight() {
        return this.outerBorder.height;
    }

    public int getOuterRightPos() {
        return this.gridElementSize.width - this.getOuterRightBorderWidth();
    }

    public int getOuterDownPos() {
        return this.gridElementSize.height - this.getOuterDownBorderHeight();
    }

    public int getOuterHorizontalSum() {
        return this.getOuterLeftPos() + this.getOuterRightBorderWidth();
    }

    public int getOuterVerticalSum() {
        return this.getOuterUpPos() + this.getOuterDownBorderHeight();
    }

    public boolean hasHorizontalDrawspace() {
        return this.gridElementSize.width > this.getOuterHorizontalSum();
    }

    public boolean hasVerticalDrawspace() {
        return this.gridElementSize.width > this.getOuterHorizontalSum();
    }

    public void draw(DrawHandler baseDrawHandler) {
        Theme currentTheme = ThemeFactory.getCurrentTheme();
        baseDrawHandler.setBackgroundColor(currentTheme.getColor(Theme.PredefinedColors.TRANSPARENT));
        baseDrawHandler.setForegroundColor(currentTheme.getColor(Theme.PredefinedColors.RED).transparency(ColorOwn.Transparency.BACKGROUND));
        baseDrawHandler.drawRectangle(this.getOuterLeftPos(), this.getOuterUpPos(), this.getOuterRightPos() - this.getOuterLeftPos() - 1, this.getOuterDownPos() - this.getOuterUpPos());
        baseDrawHandler.setForegroundColor(currentTheme.getColor(Theme.PredefinedColors.BLUE));
        baseDrawHandler.drawRectangle(this.getInnerLeftPos(), this.getInnerUpPos(), this.getInnerRightPos() - this.getInnerLeftPos(), this.getInnerDownPos() - this.getInnerUpPos());
    }
}

