/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.drawer;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.elementnew.plot.drawer.AxisConfig;
import com.baselet.element.elementnew.plot.drawer.Canvas;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class PlotDrawHandler {
    private String[] title;
    private String[] desc;
    private Double[][] values;
    private TreeSet<Double> valuesSorted;
    private TreeSet<Double> valuesShownOnAxisSorted;
    protected DrawHandler base;
    private Double minVal = null;
    private Double maxVal = null;
    private List<String> colors;
    private final Canvas canvas;
    private final AxisConfig axisConfig;

    public PlotDrawHandler(DrawHandler baseDrawHandler, Dimension size) {
        this.base = baseDrawHandler;
        this.axisConfig = new AxisConfig();
        this.canvas = new Canvas(size);
    }

    public final void drawPlotAndDescValueAxis(boolean xIsDescription, boolean drawBars, boolean drawLines, boolean drawPoints) {
        this.axisConfig.setxIsDescription(xIsDescription);
        this.setupAxis();
        this.calculateAdditionalSpaceForYAxisTextWidth();
        if (drawBars) {
            this.drawBars(xIsDescription, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors);
        }
        if (drawLines) {
            this.drawLineOrPoints(xIsDescription, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors, true);
        }
        if (drawPoints) {
            this.drawLineOrPoints(xIsDescription, this.values, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment(), this.colors, false);
        }
        if (this.axisConfig.showAxis()) {
            this.drawAxis(xIsDescription, this.axisConfig.getDescAxisPos(), this.axisConfig.getValueAxisPos(), this.axisConfig.getValueSegment(), this.axisConfig.getDescSegment());
        }
    }

    private void setupAxis() {
        Double valueRange = Math.max(1.0, this.maxVal - this.minVal);
        Double negativeRange = 0.0;
        if (this.minVal > 0.0) {
            negativeRange = 0.0;
        }
        if (this.minVal < 0.0) {
            negativeRange = this.maxVal < 0.0 ? valueRange : Double.valueOf(-this.minVal.doubleValue());
        }
        int elementCount = this.desc.length;
        for (Double[] vArray : this.values) {
            if (vArray.length <= elementCount) continue;
            elementCount = vArray.length;
        }
        if (this.axisConfig.isxDescription()) {
            this.axisConfig.setDescSegment(this.canvas.getInnerHorizontalDrawspace() / elementCount);
            this.axisConfig.setValueSegment((double)this.canvas.getInnerVerticalDrawspace() / valueRange);
            this.axisConfig.setDescAxisPos((int)((double)this.canvas.getInnerDownPos() - this.axisConfig.getValueSegment() * negativeRange));
            this.axisConfig.setValueAxisPos(this.canvas.getInnerLeftPos());
        } else {
            this.axisConfig.setDescSegment(this.canvas.getInnerVerticalDrawspace() / elementCount);
            this.axisConfig.setValueSegment((double)this.canvas.getInnerHorizontalDrawspace() / valueRange);
            this.axisConfig.setDescAxisPos((int)((double)this.canvas.getInnerLeftPos() + this.axisConfig.getValueSegment() * negativeRange));
            this.axisConfig.setValueAxisPos(this.canvas.getInnerUpPos());
        }
    }

    private final void drawAxis(boolean xIsDescription, int sourceAxisPos, int valueAxisPos, Double valueSegment, int descSegment) {
        ArrayList<Integer> xpoints = new ArrayList<Integer>();
        ArrayList<String> xtext = new ArrayList<String>();
        ArrayList<Integer> ypoints = new ArrayList<Integer>();
        ArrayList<String> ytext = new ArrayList<String>();
        int lineIterator = valueAxisPos + descSegment / 2;
        for (String d : this.desc) {
            if (xIsDescription) {
                xpoints.add(lineIterator);
                xtext.add(d);
            } else {
                ypoints.add(lineIterator);
                ytext.add(d);
            }
            lineIterator += descSegment;
        }
        for (Double v : this.valuesShownOnAxisSorted) {
            int linePos = (int)this.calculateValuePos(v, valueSegment);
            if (xIsDescription) {
                ypoints.add(sourceAxisPos - linePos);
                ytext.add(String.valueOf(v));
                continue;
            }
            xpoints.add(sourceAxisPos + linePos);
            xtext.add(String.valueOf(v));
        }
        this.drawGraylines(xpoints, ypoints);
        this.base.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.BLACK).transparency(ColorOwn.Transparency.FOREGROUND));
        this.drawAxisLine();
        this.drawMarkers(xpoints, ypoints);
        this.drawMarkerTexts(xpoints, xtext, ypoints, ytext);
    }

    private void drawAxisLine() {
        if (this.axisConfig.drawXAxis()) {
            int x1 = this.canvas.getInnerLeftPos();
            int x2 = this.canvas.getInnerRightPos();
            int y = this.axisConfig.getxAxisPos();
            this.base.drawLine(x1, y, x2, y);
        }
        if (this.axisConfig.drawYAxis()) {
            int x = this.axisConfig.getyAxisPos();
            int y1 = this.canvas.getInnerUpPos();
            int y2 = this.canvas.getInnerDownPos();
            this.base.drawLine(x, y1, x, y2);
        }
    }

    private void drawGraylines(List<Integer> xpoints, List<Integer> ypoints) {
        boolean drawHorizontalGraylines;
        this.base.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.BLACK).transparency(ColorOwn.Transparency.SELECTION_BACKGROUND));
        boolean drawVerticalGraylines = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerGrayline() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerGrayline();
        boolean bl = drawHorizontalGraylines = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerGrayline() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerGrayline();
        if (drawVerticalGraylines) {
            for (Integer x : xpoints) {
                this.base.drawLine(x.intValue(), this.canvas.getInnerUpPos(), x.intValue(), this.canvas.getInnerDownPos());
            }
        }
        if (drawHorizontalGraylines) {
            for (Integer y : ypoints) {
                this.base.drawLine(this.canvas.getInnerLeftPos(), y.intValue(), this.canvas.getInnerRightPos(), y.intValue());
            }
        }
    }

    private void drawMarkers(List<Integer> xpoints, List<Integer> ypoints) {
        boolean drawHorizontalMarkers;
        boolean drawVerticalMarkers = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkers() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkers();
        boolean bl = drawHorizontalMarkers = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkers() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkers();
        if (drawVerticalMarkers) {
            for (Integer x : xpoints) {
                this.base.drawLine(x.intValue(), this.axisConfig.getxAxisPos(), x.intValue(), this.axisConfig.getxAxisPos() + 5);
            }
        }
        if (drawHorizontalMarkers) {
            for (Integer y : ypoints) {
                this.base.drawLine(this.axisConfig.getyAxisPos() - 5, y.intValue(), this.axisConfig.getyAxisPos(), y.intValue());
            }
        }
    }

    private void drawMarkerTexts(List<Integer> xpoints, List<String> xtext, List<Integer> ypoints, List<String> ytext) {
        int i;
        boolean drawHorizontalMarkerTexts;
        boolean drawVerticalMarkerTexts = this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerText() || !this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerText();
        boolean bl = drawHorizontalMarkerTexts = !this.axisConfig.isxDescription() && this.axisConfig.drawDescriptionAxisMarkerText() || this.axisConfig.isxDescription() && this.axisConfig.drawValueAxisMarkerText();
        if (drawVerticalMarkerTexts) {
            for (i = 0; i < xpoints.size(); ++i) {
                this.base.print(xtext.get(i), (double)xpoints.get(i).intValue(), (double)(this.axisConfig.getxAxisPos() + 15), AlignHorizontal.CENTER);
            }
        }
        if (drawHorizontalMarkerTexts) {
            for (i = 0; i < ypoints.size(); ++i) {
                this.base.print(ytext.get(i), (double)(this.axisConfig.getyAxisPos() - 8), (double)((int)((double)ypoints.get(i).intValue() + this.base.textHeightMax() / 2.0)), AlignHorizontal.RIGHT);
            }
        }
    }

    private final void drawLineOrPoints(boolean xIsDescription, Double[][] values, int sourceAxisPos, int valueAxisPos, Double valueSegment, int descSegment, List<String> colors, boolean line) {
        Theme currentTheme = ThemeFactory.getCurrentTheme();
        int cIndex = 0;
        for (int valueIndex = 0; valueIndex < values.length; ++valueIndex) {
            Double[] vArray = values[valueIndex];
            int lineIterator = valueAxisPos + descSegment / 2;
            ArrayList<Point> points = new ArrayList<Point>();
            for (Double v : vArray) {
                int actualValPos = (int)this.calculateValuePos(v, valueSegment);
                if (xIsDescription) {
                    points.add(new Point(lineIterator, sourceAxisPos - actualValPos));
                } else {
                    points.add(new Point(sourceAxisPos + actualValPos, lineIterator));
                }
                lineIterator += descSegment;
            }
            if (cIndex >= colors.size()) {
                cIndex = 0;
            }
            this.base.setForegroundColor(currentTheme.forStringOrNull(colors.get(cIndex), ColorOwn.Transparency.FOREGROUND));
            this.base.setBackgroundColor(currentTheme.forStringOrNull(colors.get(cIndex), ColorOwn.Transparency.FOREGROUND));
            if (line) {
                for (int i = 0; i < points.size() - 1; ++i) {
                    Point point1 = (Point)points.get(i);
                    Point point2 = (Point)points.get(i + 1);
                    this.base.drawLine(point1.x, point1.y, point2.x, point2.y);
                }
            } else {
                for (Point point : points) {
                    this.base.drawCircle(point.x, point.y, 2.0);
                }
            }
            this.base.setForegroundColor(currentTheme.forStringOrNull(colors.get(cIndex), ColorOwn.Transparency.FOREGROUND).darken(75));
            this.base.print(this.title[valueIndex], (double)((Point)points.get((int)(points.size() - 1))).x, (double)((Point)points.get((int)(points.size() - 1))).y, AlignHorizontal.CENTER);
            ++cIndex;
        }
        this.base.resetColorSettings();
    }

    private final void drawBars(boolean xIsDescription, Double[][] values, int sourceAxisPos, int valueAxisPos, Double valueSegment, int descSegment, List<String> colors) {
        int valueRowAmount = values.length;
        for (int vIndex = 0; vIndex < valueRowAmount; ++vIndex) {
            int cIndex = 0;
            int subBarIterator = valueAxisPos;
            for (Double v : values[vIndex]) {
                if (cIndex >= colors.size()) {
                    cIndex = 0;
                }
                this.base.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.TRANSPARENT));
                this.base.setBackgroundColorAndKeepTransparency(colors.get(cIndex));
                int barLength = (int)this.calculateValuePos(v, valueSegment);
                int barWidth = 0;
                int ownvar = vIndex * (int)Math.round((double)descSegment / (double)valueRowAmount);
                barWidth = vIndex == valueRowAmount - 1 ? subBarIterator + descSegment - (subBarIterator + ownvar) : (int)Math.round((double)descSegment / (double)valueRowAmount);
                if (xIsDescription) {
                    if (barLength > 0) {
                        this.base.drawRectangle(subBarIterator + ownvar, sourceAxisPos - barLength, barWidth, barLength);
                    } else {
                        this.base.drawRectangle(subBarIterator + ownvar, sourceAxisPos, barWidth, -barLength);
                    }
                } else if (barLength > 0) {
                    this.base.drawRectangle(sourceAxisPos, subBarIterator + ownvar, barLength, barWidth);
                } else {
                    this.base.drawRectangle(sourceAxisPos + barLength, subBarIterator + ownvar, -barLength, barWidth);
                }
                subBarIterator += descSegment;
                ++cIndex;
            }
        }
        this.base.resetColorSettings();
    }

    public final void drawPiePlot() {
        int width;
        Double valueSum = 0.0;
        for (Double v : this.values[0]) {
            valueSum = valueSum + Math.abs(v);
        }
        int height = this.canvas.getInnerVerticalDrawspace();
        int diameter = height > (width = this.canvas.getInnerHorizontalDrawspace()) ? width : height;
        Point ulCorner = new Point(this.canvas.getInnerLeftPos(), this.canvas.getInnerUpPos());
        this.drawPieArcs(this.values[0], this.desc, ulCorner, diameter, valueSum, this.colors);
    }

    private final void drawPieArcs(Double[] values, String[] desc, Point ulCorner, int diameter, Double valueSum, List<String> colors) {
        Theme currentTheme = ThemeFactory.getCurrentTheme();
        int cIndex = 0;
        Double arcAngle = 0.0;
        Double startAngle = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (cIndex >= colors.size()) {
                cIndex = 0;
            }
            ColorOwn currentFg = this.base.getForegroundColor();
            this.base.setForegroundColor(currentTheme.getColor(Theme.PredefinedColors.TRANSPARENT));
            this.base.setBackgroundColorAndKeepTransparency(colors.get(cIndex));
            arcAngle = i < values.length - 1 ? (double)Math.round(360.0 / valueSum * Math.abs(values[i])) : 360.0 - startAngle;
            int height = this.canvas.getInnerVerticalDrawspace();
            int width = this.canvas.getInnerHorizontalDrawspace();
            this.base.drawArc((double)ulCorner.x + (double)width / 2.0 - (double)diameter / 2.0, (double)ulCorner.y + (double)height / 2.0 - (double)diameter / 2.0, diameter, diameter, startAngle.floatValue(), arcAngle.floatValue(), false);
            this.base.setForegroundColor(currentFg);
            double radians = (360.0 - startAngle + (360.0 - arcAngle / 2.0)) * Math.PI / 180.0;
            int value_x = (int)((double)diameter / 2.0 * Math.cos(radians) + (double)ulCorner.x + (double)diameter / 2.0 + (double)width / 2.0 - (double)diameter / 2.0);
            int value_y = (int)((double)diameter / 2.0 * Math.sin(radians) + (double)ulCorner.y + (double)diameter / 2.0 + (double)height / 2.0 - (double)diameter / 2.0);
            this.base.setForegroundColor(currentTheme.forStringOrNull(colors.get(cIndex), ColorOwn.Transparency.FOREGROUND).darken(75));
            this.base.print(desc[i], (double)value_x, (double)value_y, AlignHorizontal.CENTER);
            startAngle = startAngle + arcAngle;
            ++cIndex;
        }
        this.base.resetColorSettings();
    }

    private void calculateAdditionalSpaceForYAxisTextWidth() {
        double adjustValue;
        double maxWidth = 0.0;
        if (this.axisConfig.isxDescription()) {
            if (this.axisConfig.drawValueAxisMarkerText()) {
                for (Double v : this.valuesShownOnAxisSorted) {
                    double valueWidth = this.base.textWidth(String.valueOf(v));
                    if (!(valueWidth > maxWidth)) continue;
                    maxWidth = valueWidth;
                }
            }
        } else if (this.axisConfig.drawDescriptionAxisMarkerText()) {
            for (String d : this.desc) {
                double valueWidth = this.base.textWidth(d);
                if (!(valueWidth > maxWidth)) continue;
                maxWidth = valueWidth;
            }
        }
        if ((adjustValue = maxWidth + (double)this.canvas.getOuterLeftPos() - (double)(this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos()) - 5.0) > (double)this.canvas.getOuterLeftPos()) {
            this.canvas.setBorderX((int)adjustValue);
            this.setupAxis();
            if (this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos() != 0 && (adjustValue = maxWidth + (double)this.canvas.getOuterLeftPos() - (double)(this.axisConfig.getyAxisPos() - this.canvas.getInnerLeftPos()) - 5.0) > (double)this.canvas.getOuterLeftPos()) {
                this.canvas.setBorderX((int)adjustValue);
                this.setupAxis();
            }
        }
    }

    public double calculateValuePos(double value, double valueSegment) {
        if (value > 0.0 && this.minVal > 0.0) {
            value -= this.minVal.doubleValue();
        } else if (value < 0.0 && this.maxVal < 0.0) {
            value -= this.maxVal.doubleValue();
        }
        return value * valueSegment;
    }

    public void setValues(String[] desc, String[] title, Double[][] values, List<String> colors) {
        this.desc = SharedUtils.cloneArray(desc);
        this.title = SharedUtils.cloneArray(title);
        this.colors = new ArrayList<String>(colors);
        this.values = SharedUtils.cloneArray(values);
        this.valuesSorted = new TreeSet();
        Double[][] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            Double[] vArray;
            for (Double v : vArray = doubleArray[i]) {
                this.valuesSorted.add(v);
            }
        }
        this.valuesShownOnAxisSorted = this.axisConfig.setValueAxisList(this.valuesSorted);
        this.minVal = this.minRealOrShownValue();
        this.maxVal = this.maxRealOrShownValue();
    }

    public void setMinValue(Double minVal) throws IOException {
        Double limit = Math.min(this.minRealOrShownValue(), this.maxVal);
        if (minVal > limit) {
            throw new IOException("minValue must be <= " + limit);
        }
        this.minVal = minVal;
    }

    public void setMaxValue(Double maxVal) throws IOException {
        Double limit = Math.max(this.maxRealOrShownValue(), this.minVal);
        if (maxVal < limit) {
            throw new IOException("maxValue must be >= " + limit);
        }
        this.maxVal = maxVal;
    }

    private double minRealOrShownValue() {
        if (this.valuesShownOnAxisSorted.isEmpty()) {
            return this.valuesSorted.first();
        }
        return Math.min(this.valuesSorted.first(), this.valuesShownOnAxisSorted.first());
    }

    private double maxRealOrShownValue() {
        if (this.valuesShownOnAxisSorted.isEmpty()) {
            return this.valuesSorted.last();
        }
        return Math.max(this.valuesSorted.last(), this.valuesShownOnAxisSorted.last());
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public AxisConfig getAxisConfig() {
        return this.axisConfig;
    }

    public static enum Position {
        LEFT,
        UP,
        DOWN,
        RIGHT;

    }
}

