/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.elements;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.elementnew.plot.drawer.PlotDrawHandler;
import com.baselet.element.elementnew.plot.drawer.PlotGridDrawConfig;
import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.PlotConstants;
import com.baselet.element.elementnew.plot.parser.PlotState;
import java.util.List;

public abstract class AbstractPlot {
    protected PlotDrawHandler plot;
    protected PlotGridDrawConfig plotDrawConfig;
    protected PlotState plotState;
    private final Integer xPosition;
    private final Integer yPosition;

    public AbstractPlot(DrawHandler drawer, PlotGridDrawConfig plotDrawConfig, PlotState plotState, int xPosition, int yPosition) {
        this.plotDrawConfig = plotDrawConfig;
        this.plotState = plotState;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.plot = new PlotDrawHandler(drawer, plotDrawConfig.getRealSize());
        this.setupAxis();
        this.setupAbstractPlot();
    }

    public Integer getPlotLineNr() {
        return this.plotState.getPlotLineNr();
    }

    public Integer getXPosition() {
        return this.xPosition;
    }

    public Integer getYPosition() {
        return this.yPosition;
    }

    private void setupAxis() {
        this.plot.getAxisConfig().enableDescAxis(this.plotState.getValueListValidated(PlotConstants.AxisShow.getKeyDescAxis(), PlotConstants.toStringList(this.defaultDescAxisShow()), PlotConstants.toStringList(PlotConstants.AxisShow.values()), false));
        this.plot.getAxisConfig().enableValueAxis(this.plotState.getValueListValidated(PlotConstants.AxisShow.getKeyValueAxis(), PlotConstants.toStringList(this.defaultValueAxisShow()), PlotConstants.toStringList(PlotConstants.AxisShow.values()), false), this.plotState.getValueListValidated(PlotConstants.AxisList.getKey(), PlotConstants.toStringList(this.defaultValueAxisList()), PlotConstants.toStringList(PlotConstants.AxisList.values()), true));
    }

    private void setupAbstractPlot() {
        DataSet ds = this.plotState.getDataSet();
        ds.setInvert(this.plotState.getValueAsBoolean("data.invert", PlotConstants.DATA_INVERT_DEFAULT));
        String[] desc = ds.titleRow();
        String[] title = ds.titleCol();
        Double[][] values = ds.data();
        List<String> colors = this.plotState.getValueList("colors", PlotConstants.COLORS_DEFAULT);
        for (String color : colors) {
            if (ThemeFactory.getCurrentTheme().forStringOrNull(color, ColorOwn.Transparency.FOREGROUND) != null) continue;
            throw new ParserException("Unknown color: " + color + "(line: " + this.plotState.getLine("colors") + ")");
        }
        if (values.length > this.getMaxAllowedValueRows()) {
            throw new ParserException("The dataset (line: " + this.plotState.getDataSet().getLineNr() + ") has too many rows for the plot (line: " + this.plotState.getPlotLineNr() + ")");
        }
        this.plot.setValues(desc, title, values, colors);
        this.setMinMaxValue("value.min");
        this.setMinMaxValue("value.max");
    }

    private void setMinMaxValue(String key) {
        String stringValue = this.plotState.getValue(key, null);
        if (stringValue != null) {
            try {
                if (key.equals("value.min")) {
                    if (stringValue.equals("all")) {
                        this.plot.setMinValue(this.plotDrawConfig.getMinValue());
                    } else {
                        this.plot.setMinValue(Double.valueOf(stringValue));
                    }
                } else if (key.equals("value.max")) {
                    if (stringValue.equals("all")) {
                        this.plot.setMaxValue(this.plotDrawConfig.getMaxValue());
                    } else {
                        this.plot.setMaxValue(Double.valueOf(stringValue));
                    }
                }
            }
            catch (Exception e) {
                throw new ParserException(key, stringValue, this.plotState.getLine(key), e.getMessage());
            }
        }
    }

    protected void setPlotPosition(int columnCount, int rowCount) {
        if (this.xPosition > columnCount) {
            throw new ParserException("The x coordinate is invalid. PlotGrid width is too small");
        }
        if (this.yPosition > rowCount) {
            throw new ParserException("The y coordinate is invalid. PlotGrid height is too small");
        }
        double segmentWidth = (double)this.plotDrawConfig.getRealSize().width / (double)columnCount;
        double segmentHeight = (double)this.plotDrawConfig.getRealSize().height / (double)rowCount;
        int spaceLeft = (int)(segmentWidth * (double)this.xPosition.intValue());
        int spaceRight = (int)(segmentWidth * (double)(columnCount - this.xPosition - 1));
        int spaceTop = (int)(segmentHeight * (double)this.yPosition.intValue());
        int spaceBottom = (int)(segmentHeight * (double)(rowCount - this.yPosition - 1));
        this.plot.getCanvas().setBorder(spaceLeft, spaceTop, spaceRight, spaceBottom, 15);
    }

    public abstract void plot(int var1, int var2);

    protected abstract List<PlotConstants.AxisShow> defaultDescAxisShow();

    protected abstract List<PlotConstants.AxisShow> defaultValueAxisShow();

    protected abstract List<PlotConstants.AxisList> defaultValueAxisList();

    protected abstract int getMaxAllowedValueRows();
}

