/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.uml;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.NewGridElement;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.SeparatorLineFacet;
import com.baselet.element.settings.SettingsManualResizeTop;
import java.util.Arrays;
import java.util.List;

public class Deployment
extends NewGridElement {
    private static final int BORDER = 10;

    @Override
    protected Settings createSettings() {
        return new SettingsManualResizeTop(){

            @Override
            protected List<Facet> createFacets() {
                return 1.listOf(super.createFacets(), SeparatorLineFacet.INSTANCE);
            }
        };
    }

    @Override
    public ElementId getId() {
        return ElementId.UMLDeployment;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        double w = this.getRealSize().getWidth();
        double h = this.getRealSize().getHeight();
        List<PointDouble> p = Arrays.asList(new PointDouble(0.0, 10.0), new PointDouble(10.0, 0.0), new PointDouble(w, 0.0), new PointDouble(w, h - 10.0), new PointDouble(w - 10.0, h));
        PointDouble pLine = new PointDouble(w - 10.0, 10.0);
        Style oldStyle = drawer.getStyleClone();
        Theme currentTheme = ThemeFactory.getCurrentTheme();
        drawer.setForegroundColor(currentTheme.getColor(Theme.PredefinedColors.TRANSPARENT));
        if (oldStyle.getBackgroundColor() == currentTheme.getColor(Theme.ColorStyle.DEFAULT_BACKGROUND)) {
            drawer.setBackgroundColor(currentTheme.getColor(Theme.PredefinedColors.WHITE).transparency(ColorOwn.Transparency.BACKGROUND).darken(80));
        } else {
            drawer.setBackgroundColor(oldStyle.getBackgroundColor().darken(80));
        }
        drawer.drawLines(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4), pLine, p.get(0));
        drawer.setStyle(oldStyle);
        drawer.drawLines(p);
        drawer.drawLines(pLine, p.get(2));
        drawer.drawRectangle(0.0, 10.0, w - 10.0, h - 10.0);
        state.getBuffer().setTopMin(10.0);
        state.getBuffer().addToRight(10.0);
    }
}

