/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.enums.FormatLabels;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public abstract class KeyValueFacet
extends Facet {
    public static final String SEP = "=";

    public abstract KeyValue getKeyValue();

    public abstract void handleValue(String var1, PropertiesParserState var2);

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return line.startsWith(this.getKeyWithSep());
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
        String value = this.extractValue(line);
        try {
            this.handleValue(value, state);
        }
        catch (Exception e) {
            this.log.debug("KeyValue Error", (Throwable)e);
            String errorMessage = this.getKeyValue().getValueString();
            if (e instanceof StyleException) {
                errorMessage = e.getMessage();
            }
            throw new RuntimeException(FormatLabels.BOLD.getValue() + "Invalid value:" + FormatLabels.BOLD.getValue() + "\n" + this.getKeyWithSep() + value + "\n" + errorMessage);
        }
    }

    protected String extractValue(String line) {
        return line.substring(this.getKeyWithSep().length());
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        ArrayList<AutocompletionText> returnList = new ArrayList<AutocompletionText>();
        for (ValueInfo valueInfo : this.getKeyValue().getValueInfos()) {
            returnList.add(new AutocompletionText(this.getKeyWithSep() + valueInfo.getValue().toString().toLowerCase(Locale.ENGLISH), valueInfo.getInfo(), valueInfo.getBase64Img()));
        }
        return returnList;
    }

    public String getKeyWithSep() {
        return this.getKeyValue().getKey() + SEP;
    }

    public static class ValueInfo {
        private final Object value;
        private final String info;
        private final String base64Img;

        public ValueInfo(Object value, String info) {
            this(value, info, null);
        }

        public ValueInfo(Object value, String info, String base64Img) {
            this.value = value;
            this.info = info;
            this.base64Img = base64Img;
        }

        public Object getValue() {
            return this.value;
        }

        private String getInfo() {
            return this.info;
        }

        private String getBase64Img() {
            return this.base64Img;
        }
    }

    public static class KeyValue {
        private final String key;
        private final boolean allValuesListed;
        private final List<ValueInfo> valueInfos;

        public KeyValue(String key, boolean allValuesListed, String value, String info) {
            this.key = key.toLowerCase(Locale.ENGLISH);
            this.allValuesListed = allValuesListed;
            this.valueInfos = Arrays.asList(new ValueInfo(value, info));
        }

        public KeyValue(String key, List<ValueInfo> valueInfos) {
            this.key = key;
            this.allValuesListed = true;
            this.valueInfos = valueInfos;
        }

        public KeyValue(String key, ValueInfo ... valueInfos) {
            this(key, Arrays.asList(valueInfos));
        }

        public String getKey() {
            return this.key;
        }

        public List<ValueInfo> getValueInfos() {
            return this.valueInfos;
        }

        public String getValueString() {
            StringBuilder sb = new StringBuilder();
            if (this.allValuesListed) {
                sb.append("Valid are: ");
                for (ValueInfo vi : this.valueInfos) {
                    sb.append(vi.value.toString().toLowerCase(Locale.ENGLISH)).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            } else {
                for (ValueInfo vi : this.valueInfos) {
                    sb.append(vi.info);
                }
            }
            return sb.toString();
        }
    }
}

