/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.common;

import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupFacet
extends FirstRunKeyValueFacet {
    public static final GroupFacet INSTANCE = new GroupFacet();
    public static final String KEY = "group";
    public static final String VALUE_PREFIX = "group";
    private static final int KEY_START_VAL = 0;
    public static final AtomicInteger LAST_KNOWN_VAL = new AtomicInteger(0);

    private GroupFacet() {
    }

    public static final String nextDefaultKey() {
        return "group-" + LAST_KNOWN_VAL.getAndIncrement();
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("group", false, "group-0", "grouped elements are selected at once");
    }

    public static String getElementGroupValSafe(String arg_group) {
        if (arg_group == null || arg_group.length() == 0) {
            return null;
        }
        String _res = arg_group.trim();
        if (_res.length() == 0) {
            return null;
        }
        return _res;
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
        String safeValue = GroupFacet.getElementGroupValSafe(value);
        if (safeValue == null || !value.equals(safeValue)) {
            if (value.length() > 0) {
                throw new StyleException("Group value cannot have whitespaces at the start or end");
            }
            throw new StyleException("Group value cannot be empty");
        }
        state.setFacetResponse(GroupFacet.class, value);
    }
}

