/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.facet.Alignment;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class InnerClassFacet
extends Facet {
    public static final InnerClassFacet INSTANCE = new InnerClassFacet();
    private static final int BUFFER_PIXEL_PER_INNER = 5;
    private static final int H_SPACE = 4;
    private static final String START = "{innerclass";
    private static final String END = "innerclass}";

    private InnerClassFacet() {
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return line.equals(START) || line.equals(END);
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
        Stack<ClassSettings> innerClassStartPoints = this.getOrInit(state);
        DrawHandler drawer = state.getDrawer();
        if (line.equals(START)) {
            ClassSettings settings = new ClassSettings(state.getAlignment().getHorizontal(), state.getAlignment().getVertical(), this.getDividerPos(drawer, state));
            innerClassStartPoints.add(settings);
            state.getBuffer().addToLeftAndRight(5.0);
            state.increaseTextPrintPosition(4.0);
            state.getAlignment().reset();
        } else if (line.equals(END)) {
            ClassSettings previousClassSettings = innerClassStartPoints.pop();
            double start = previousClassSettings.start;
            double height = this.getDividerPos(drawer, state) - start;
            XValues xLimit = state.getXLimits(height);
            ColorOwn oldColor = drawer.getBackgroundColor();
            drawer.setBackgroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.TRANSPARENT));
            drawer.drawRectangle(xLimit.getLeft(), start, xLimit.getSpace(), height);
            drawer.setBackgroundColor(oldColor);
            state.increaseTextPrintPosition(4.0);
            state.getBuffer().addToLeftAndRight(-5.0);
            Alignment alignment = state.getAlignment();
            alignment.setHorizontal(false, previousClassSettings.hAlign);
            alignment.setVertical(false, previousClassSettings.vAlign);
        }
    }

    private double getDividerPos(DrawHandler drawer, PropertiesParserState state) {
        return state.getTextPrintPosition() - drawer.textHeightMax();
    }

    private Stack<ClassSettings> getOrInit(PropertiesParserState state) {
        return state.getOrInitFacetResponse(InnerClassFacet.class, new Stack());
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText(START, "begin inner class"), new AutocompletionText(END, "end inner class"));
    }

    private static class ClassSettings {
        private final AlignHorizontal hAlign;
        private final AlignVertical vAlign;
        private final double start;

        public ClassSettings(AlignHorizontal hAlign, AlignVertical vAlign, double startpoint) {
            this.hAlign = hAlign;
            this.vAlign = vAlign;
            this.start = startpoint;
        }
    }
}

