/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.XValues;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.List;
import java.util.Locale;

public class SpecialStateTypeFacet
extends KeyValueFacet {
    public static final SpecialStateTypeFacet INSTANCE = new SpecialStateTypeFacet();

    private SpecialStateTypeFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("type", new KeyValueFacet.ValueInfo((Object)StateTypeEnum.INITIAL, "an initial state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.FINAL, "a final state for the activity"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.FLOW_FINAL, "a final state for a flow"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.HISTORY_SHALLOW, "a shallow history state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.HISTORY_DEEP, "a deep history state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.TERMINATION, "a termination state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.DECISION, "a decision"));
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        StateTypeEnum type = StateTypeEnum.valueOf(value.toUpperCase(Locale.ENGLISH));
        Dimension s = state.getGridElementSize();
        double w = this.getWidth(s);
        double h = this.getHeight(s);
        if (type == StateTypeEnum.INITIAL) {
            this.drawBlackEllipse(drawer, w - 1.0, h - 1.0, 1.0);
        } else if (type == StateTypeEnum.FINAL) {
            drawer.drawEllipse(0.0, 0.0, w, h);
            ColorOwn oldFg = drawer.getForegroundColor();
            drawer.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.TRANSPARENT));
            double ellipseDistance = Math.max(w - 1.0, h - 1.0) / 5.5;
            this.drawBlackEllipse(drawer, w - ellipseDistance * 2.0, h - ellipseDistance * 2.0, ellipseDistance);
            drawer.setForegroundColor(oldFg);
        } else if (type == StateTypeEnum.FLOW_FINAL) {
            drawer.drawEllipse(0.0, 0.0, w, h);
            double upperY = h / 6.0;
            double lowerY = h - upperY;
            XValues upperXVal = XValues.createForEllipse(upperY, h, w);
            XValues lowerXVal = XValues.createForEllipse(lowerY, h, w);
            drawer.drawLine(upperXVal.getLeft(), upperY, lowerXVal.getRight(), lowerY);
            drawer.drawLine(lowerXVal.getLeft(), lowerY, upperXVal.getRight(), upperY);
        } else if (type == StateTypeEnum.HISTORY_SHALLOW || type == StateTypeEnum.HISTORY_DEEP) {
            String text = type == StateTypeEnum.HISTORY_SHALLOW ? "*H*" : "*H**";
            drawer.drawEllipse(0.0, 0.0, w, h);
            double x = (w - drawer.textWidth(text)) / 2.0;
            double y = (h + drawer.textHeight(text)) / 2.0;
            drawer.print(text, new PointDouble(x, y), AlignHorizontal.LEFT);
        } else if (type == StateTypeEnum.TERMINATION) {
            drawer.drawLine(0.0, 0.0, w, h);
            drawer.drawLine(w, 0.0, 0.0, h);
        } else if (type == StateTypeEnum.DECISION) {
            this.drawDecision(drawer, w, h);
        }
    }

    private void drawDecision(DrawHandler drawer, double w, double h) {
        drawer.drawLines(new PointDouble(0.5 + w / 2.0, 1.0), new PointDouble(w, 0.5 + h / 2.0), new PointDouble(0.5 + w / 2.0, h), new PointDouble(1.0, 0.5 + h / 2.0), new PointDouble(0.5 + w / 2.0, 1.0));
    }

    private void drawBlackEllipse(DrawHandler drawer, double width, double height, double xY) {
        ColorOwn oldBg = drawer.getBackgroundColor();
        Theme currentTheme = ThemeFactory.getCurrentTheme();
        if (drawer.getBackgroundColor() == currentTheme.getColor(Theme.ColorStyle.DEFAULT_BACKGROUND)) {
            drawer.setBackgroundColor(currentTheme.getColor(Theme.PredefinedColors.BLACK).transparency(ColorOwn.Transparency.FOREGROUND));
        } else {
            drawer.setBackgroundColor(drawer.getBackgroundColor().transparency(ColorOwn.Transparency.FOREGROUND));
        }
        drawer.drawEllipse(xY, xY, width, height);
        drawer.setBackgroundColor(oldBg);
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        if (handledLines.isEmpty()) {
            Dimension s = state.getGridElementSize();
            this.drawDecision(state.getDrawer(), this.getWidth(s), this.getHeight(s));
        }
    }

    private int getHeight(Dimension s) {
        return s.getHeight() - 1;
    }

    private int getWidth(Dimension s) {
        return s.getWidth() - 1;
    }

    private static enum StateTypeEnum {
        INITIAL,
        FINAL,
        FLOW_FINAL,
        TERMINATION,
        DECISION,
        HISTORY_SHALLOW,
        HISTORY_DEEP;

    }
}

