/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class StateTypeFacet
extends FirstRunKeyValueFacet {
    public static final StateTypeFacet INSTANCE = new StateTypeFacet();

    private StateTypeFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("type", new KeyValueFacet.ValueInfo((Object)ActionTypeEnum.STATE, "a default state"), new KeyValueFacet.ValueInfo((Object)ActionTypeEnum.SENDER, "an action which sends a signal"), new KeyValueFacet.ValueInfo((Object)ActionTypeEnum.RECEIVER, "an action which receives a signal"));
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
    }

    private void drawActionState(DrawHandler drawer, Dimension s) {
        int radius = Math.min(20, Math.min(s.width, s.height) / 5);
        drawer.drawRectangleRound(0.0, 0.0, s.width, s.height, radius);
    }

    private double depth(Dimension s) {
        return (double)s.width / 5.0;
    }

    private PointDouble p(double x, double y) {
        return new PointDouble(x, y);
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        if (handledLines.isEmpty()) {
            this.drawActionState(state.getDrawer(), state.getGridElementSize());
        } else if (handledLines.size() == 1) {
            PropertiesParserState state1 = state;
            DrawHandler drawer = state1.getDrawer();
            ActionTypeEnum type = ActionTypeEnum.valueOf(this.extractValue(handledLines.get(0).toUpperCase(Locale.ENGLISH)));
            Dimension s = state1.getGridElementSize();
            if (type == ActionTypeEnum.STATE) {
                this.drawActionState(drawer, s);
            } else if (type == ActionTypeEnum.SENDER) {
                drawer.drawLines(Arrays.asList(this.p(0.0, 0.0), this.p((double)s.width - this.depth(s), 0.0), this.p(s.width, (double)s.height / 2.0), this.p((double)s.width - this.depth(s), s.height), this.p(0.0, s.height), this.p(0.0, 0.0)));
            } else if (type == ActionTypeEnum.RECEIVER) {
                state1.getBuffer().addToLeft(this.depth(s));
                drawer.drawLines(Arrays.asList(this.p(0.0, 0.0), this.p(s.width, 0.0), this.p(s.width, s.height), this.p(0.0, s.height), this.p(this.depth(s), (double)s.height / 2.0), this.p(0.0, 0.0)));
            }
        }
    }

    private static enum ActionTypeEnum {
        STATE,
        SENDER,
        RECEIVER;

    }
}

