/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class UpperRightSymbolFacet
extends FirstRunKeyValueFacet {
    public static final UpperRightSymbolFacet INSTANCE = new UpperRightSymbolFacet();
    private static final int DISTANCE = 5;

    private UpperRightSymbolFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("symbol", new KeyValueFacet.ValueInfo((Object)UpperRightSymbolEnum.USECASE, "draw a use case symbol"), new KeyValueFacet.ValueInfo((Object)UpperRightSymbolEnum.ARTIFACT, "draw an artifact symbol"), new KeyValueFacet.ValueInfo((Object)UpperRightSymbolEnum.COMPONENT, "draw a component symbol"));
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
        UpperRightSymbolEnum symbol = UpperRightSymbolEnum.valueOf(value.toUpperCase(Locale.ENGLISH));
        state.setFacetResponse(UpperRightSymbolFacet.class, (Object)symbol);
    }

    public static void drawAndSetBuffer(PropertiesParserState state, UpperRightSymbolEnum symbol) {
        DrawHandler drawer = state.getDrawer();
        ColorOwn prevBackgroundColor = drawer.getBackgroundColor();
        drawer.setBackgroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.TRANSPARENT));
        double eW = state.getGridElementSize().getWidth();
        double fs = drawer.getFontSize();
        if (symbol == UpperRightSymbolEnum.USECASE) {
            double cW = fs * 2.5;
            double cH = fs;
            drawer.drawEllipse(eW - cW - 5.0, 5.0, cW, cH);
            state.getBuffer().setTopMin(5.0);
        } else if (symbol == UpperRightSymbolEnum.ARTIFACT) {
            double cW = fs * 1.5;
            double cH = fs * 1.8;
            double corner = fs * 0.5;
            List<PointDouble> p = Arrays.asList(new PointDouble(eW - cW - 5.0, 5.0), new PointDouble(eW - 5.0 - corner, 5.0), new PointDouble(eW - 5.0, 5.0 + corner), new PointDouble(eW - 5.0, 5.0 + cH), new PointDouble(eW - cW - 5.0, 5.0 + cH));
            PointDouble px = new PointDouble(eW - 5.0 - corner, 5.0 + corner);
            drawer.drawLines(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4), p.get(0));
            drawer.drawLines(p.get(1), px, p.get(2));
            state.getBuffer().setTopMin(5.0 + fs * 0.3);
        } else if (symbol == UpperRightSymbolEnum.COMPONENT) {
            double partHeight = fs * 0.4;
            double nonPartHeight = fs * 0.3;
            double partWidth = partHeight * 2.0;
            double cH = partHeight * 2.0 + nonPartHeight * 3.0;
            double cW = cH * 0.8;
            drawer.drawRectangle(eW - cW - partWidth / 2.0 - 5.0, 5.0 + nonPartHeight, partWidth, partHeight);
            drawer.drawRectangle(eW - cW - partWidth / 2.0 - 5.0, 5.0 + partHeight + nonPartHeight * 2.0, partWidth, partHeight);
            drawer.drawLine(eW - cW - 5.0, 5.0 + partHeight + nonPartHeight, eW - cW - 5.0, 5.0 + partHeight + nonPartHeight * 2.0);
            drawer.drawLines(Arrays.asList(new PointDouble(eW - cW - 5.0, 5.0 + nonPartHeight), new PointDouble(eW - cW - 5.0, 5.0), new PointDouble(eW - 5.0, 5.0), new PointDouble(eW - 5.0, 5.0 + cH), new PointDouble(eW - cW - 5.0, 5.0 + cH), new PointDouble(eW - cW - 5.0, 5.0 + cH - nonPartHeight)));
            state.getBuffer().setTopMin(5.0 + fs * 0.3);
        }
        drawer.setBackgroundColor(prevBackgroundColor);
    }

    public static enum UpperRightSymbolEnum {
        USECASE,
        ARTIFACT,
        COMPONENT;

    }
}

