/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.relation.helper.LineDescriptionBasePositionEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LineDescriptionBasePositionFacet
extends FirstRunKeyValueFacet {
    public static final LineDescriptionBasePositionFacet INSTANCE = new LineDescriptionBasePositionFacet();

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        ArrayList<KeyValueFacet.ValueInfo> cs = new ArrayList<KeyValueFacet.ValueInfo>();
        cs.add(new KeyValueFacet.ValueInfo("l", "middle text is positioned left to the line"));
        cs.add(new KeyValueFacet.ValueInfo("r", "middle text is positioned right to the line"));
        cs.add(new KeyValueFacet.ValueInfo("u", "middle text is positioned up the line"));
        cs.add(new KeyValueFacet.ValueInfo("d", "middle text is positioned down the line"));
        cs.add(new KeyValueFacet.ValueInfo("ru", "middle text is positioned right and up the line"));
        cs.add(new KeyValueFacet.ValueInfo("rd", "middle text is positioned right and down the line"));
        cs.add(new KeyValueFacet.ValueInfo("lu", "middle text is positioned left and up the line"));
        cs.add(new KeyValueFacet.ValueInfo("ld", "middle text is positioned left and down the line"));
        return new KeyValueFacet.KeyValue("cbase", cs);
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
        List descriptionBasePositionEnums = state.getOrInitFacetResponse(LineDescriptionBasePositionFacet.class, new ArrayList());
        for (int i = 0; i < value.length(); ++i) {
            String basePositionCommand = String.valueOf(value.charAt(i));
            LineDescriptionBasePositionEnum basePositionEnum = LineDescriptionBasePositionEnum.fromString(basePositionCommand);
            this.validateBasePositionValues(descriptionBasePositionEnums, basePositionEnum);
        }
    }

    private void validateBasePositionValues(List<LineDescriptionBasePositionEnum> descriptionBasePositionEnums, LineDescriptionBasePositionEnum basePositionEnum) {
        if (!Arrays.asList(LineDescriptionBasePositionEnum.values()).contains((Object)basePositionEnum)) {
            throw new StyleException("Allowed values: r l u d");
        }
        if (descriptionBasePositionEnums.contains((Object)basePositionEnum)) {
            throw new StyleException("Only unique base pos values allowed");
        }
        descriptionBasePositionEnums.add(basePositionEnum);
        if (descriptionBasePositionEnums.size() > 2) {
            throw new StyleException("Max amount of base position values is 2");
        }
        if (descriptionBasePositionEnums.contains((Object)LineDescriptionBasePositionEnum.MESSAGE_MIDDLE_LEFT) && descriptionBasePositionEnums.contains((Object)LineDescriptionBasePositionEnum.MESSAGE_MIDDLE_RIGHT)) {
            throw new StyleException("Cannot combine right and left");
        }
        if (descriptionBasePositionEnums.contains((Object)LineDescriptionBasePositionEnum.MESSAGE_MIDDLE_UP) && descriptionBasePositionEnums.contains((Object)LineDescriptionBasePositionEnum.MESSAGE_MIDDLE_DOWN)) {
            throw new StyleException("Cannot combine up and down");
        }
    }
}

