/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.relation.helper.LineDescriptionBasePositionEnum;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;
import java.util.List;

public class LineDescriptionUtils {
    static PointDouble calcPosOfLineDescriptionText(DrawHandler drawer, String text, int lineNr, int totalLines, RelationPointHandler relationPoints, LineDescriptionEnum enumVal) {
        double textWidth = LineDescriptionUtils.calcWidth(drawer, text);
        double totalBlock = (double)totalLines * drawer.textHeightMax();
        double previousLinesBlock = (double)lineNr * drawer.textHeightMax();
        Boolean printOnStart = enumVal.isStart();
        Line line = printOnStart != false ? relationPoints.getFirstLine() : relationPoints.getLastLine();
        PointDouble pointText = line.getPointOnLineWithDistanceFrom(printOnStart, 15.0);
        Direction lineDirection = line.getDirectionOfLine(printOnStart);
        if (lineDirection == Direction.RIGHT) {
            pointText = new PointDouble(pointText.getX() - textWidth - drawer.getDistanceBorderToText(), pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.LEFT) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.UP) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.DOWN) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() - totalBlock + previousLinesBlock - 1.0);
        }
        if (enumVal.isRoleStartOrEnd()) {
            pointText = lineDirection == Direction.UP ? new PointDouble(pointText.getX(), pointText.getY() + drawer.textHeightMaxWithSpace()) : (lineDirection == Direction.DOWN ? new PointDouble(pointText.getX(), pointText.getY() - drawer.textHeightMaxWithSpace()) : new PointDouble(pointText.getX(), pointText.getY() - (double)totalLines * drawer.textHeightMax() - 5.0));
        }
        return pointText;
    }

    private static double calcWidth(DrawHandler drawer, String ... text) {
        double maxWidth = 0.0;
        for (String line : text) {
            maxWidth = Math.max(maxWidth, drawer.textWidth(line));
        }
        return maxWidth;
    }

    static String replaceArrowsWithUtf8Characters(String text) {
        if (text.startsWith("< ")) {
            text = "\u25c4" + text.substring(1);
        }
        if (text.endsWith(" >")) {
            text = text.substring(0, text.length() - 1) + "\u25ba";
        } else if (text.endsWith(" ^")) {
            text = text.substring(0, text.length() - 1) + "\u25b2";
        } else if (text.endsWith(" v")) {
            text = text.substring(0, text.length() - 1) + "\u25bc";
        }
        return text;
    }

    static PointDouble calcPosOfMiddleText(DrawHandler drawer, String text, int currentLineNr, double halfMiddleBlockHeight, RelationPointHandler relationPoints, List<LineDescriptionBasePositionEnum> basePositions) {
        PointDouble pointText;
        double textWidth = LineDescriptionUtils.calcWidth(drawer, text);
        PointDouble center = relationPoints.getRelationCenter();
        boolean horizontalLine = relationPoints.getLineContaining(center).getDirectionOfLine(true).isHorizontal();
        double previousLinesUsedSpace = (double)currentLineNr * drawer.textHeightMaxWithSpace();
        if (horizontalLine) {
            double textX = center.getX() - textWidth / 2.0;
            double textY = center.getY() + previousLinesUsedSpace - 4.0;
            pointText = new PointDouble(textX, textY);
        } else {
            double textX = center.getX() + 4.0;
            double textY = center.getY() + previousLinesUsedSpace - halfMiddleBlockHeight + drawer.textHeightMaxWithSpace();
            pointText = new PointDouble(textX, textY);
        }
        if (!basePositions.isEmpty()) {
            pointText = LineDescriptionUtils.processBasePositionCommand(drawer, halfMiddleBlockHeight, basePositions, textWidth, center, pointText, previousLinesUsedSpace);
        }
        return pointText;
    }

    private static PointDouble processBasePositionCommand(DrawHandler drawer, double halfMiddleBlockHeight, List<LineDescriptionBasePositionEnum> basePositions, double textWidth, PointDouble center, PointDouble pointText, double previousLinesUsedSpace) {
        double textX = center.getX() - textWidth / 2.0;
        double textY = pointText.getY();
        for (LineDescriptionBasePositionEnum basePosition : basePositions) {
            if (basePosition == null) continue;
            switch (basePosition) {
                case MESSAGE_MIDDLE_RIGHT: {
                    textX = center.getX() + 4.0;
                    break;
                }
                case MESSAGE_MIDDLE_LEFT: {
                    textX = center.getX() - 4.0 - textWidth;
                    break;
                }
                case MESSAGE_MIDDLE_UP: {
                    textY = center.getY() + previousLinesUsedSpace - halfMiddleBlockHeight;
                    break;
                }
                case MESSAGE_MIDDLE_DOWN: {
                    textY = center.getY() + previousLinesUsedSpace + 4.0 + drawer.textHeightMaxWithSpace();
                    break;
                }
            }
        }
        return new PointDouble(textX, textY);
    }
}

