/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class RelationPointList {
    List<RelationPoint> points = new ArrayList<RelationPoint>();
    Map<Integer, Rectangle> textBoxSpaces = new HashMap<Integer, Rectangle>();

    public void add(double x, double y) {
        this.points.add(new RelationPoint(this.points.size(), x, y));
    }

    public List<RelationPoint> getPointHolders() {
        return Collections.unmodifiableList(this.points);
    }

    public PointDoubleIndexed addPointOnLine(Line line, double x, double y) {
        RelationPoint newPoint = null;
        PointDouble endOfLine = line.getStart();
        ListIterator<RelationPoint> iter = this.points.listIterator();
        while (iter.hasNext()) {
            PointDoubleIndexed point = iter.next().getPoint();
            if (!point.equals(endOfLine)) continue;
            newPoint = new RelationPoint(iter.nextIndex(), x, y);
            iter.add(newPoint);
        }
        this.rebuildpointIndexes();
        if (newPoint == null) {
            throw new RuntimeException("Point " + endOfLine + " not found in list " + this.points);
        }
        return newPoint.getPoint();
    }

    private void rebuildpointIndexes() {
        ArrayList<RelationPoint> rebuiltList = new ArrayList<RelationPoint>();
        for (int i = 0; i < this.points.size(); ++i) {
            rebuiltList.add(new RelationPoint(i, this.points.get(i).getPoint().getX(), this.points.get(i).getPoint().getY()));
        }
        this.points.clear();
        this.points.addAll(rebuiltList);
    }

    public void applyChangesToPoints(List<PointChange> changes) {
        this.applyPointChange(changes);
    }

    private void applyPointChange(List<PointChange> changes) {
        ListIterator<RelationPoint> iter = this.points.listIterator();
        while (iter.hasNext()) {
            RelationPoint p = iter.next();
            PointDoubleIndexed pt = p.getPoint();
            for (PointChange change : changes) {
                if (!pt.getIndex().equals(change.getIndex())) continue;
                iter.set(new RelationPoint(pt.getIndex(), pt.getX() + (double)change.getDiffX(), pt.getY() + (double)change.getDiffY(), p.getSize()));
            }
        }
    }

    void moveRelationPointsAndTextSpacesByToUpperLeftCorner() {
        Rectangle rect = this.createRectangleContainingAllPointsAndTextSpace();
        int displacementX = SharedUtils.realignToGrid(false, rect.getX(), false);
        int displacementY = SharedUtils.realignToGrid(false, rect.getY(), false);
        this.moveRelationPointsAndTextSpacesBy(-displacementX, -displacementY);
    }

    void moveRelationPointsAndTextSpacesBy(int displacementX, int displacementY) {
        ListIterator<RelationPoint> iter = this.points.listIterator();
        while (iter.hasNext()) {
            RelationPoint p = iter.next();
            iter.set(new RelationPoint(p.getPoint().getIndex(), p.getPoint().getX() + (double)displacementX, p.getPoint().getY() + (double)displacementY, p.getSize()));
        }
        for (Map.Entry<Integer, Rectangle> textSpace : this.textBoxSpaces.entrySet()) {
            Rectangle old = textSpace.getValue();
            textSpace.setValue(new Rectangle(old.getX() + displacementX, old.getY() + displacementY, old.getWidth(), old.getHeight()));
        }
    }

    public boolean removeRelationPointIfOnLineBetweenNeighbourPoints() {
        boolean updateNecessary = false;
        if (this.points.size() > 2) {
            ListIterator<RelationPoint> iter = this.points.listIterator();
            PointDoubleIndexed leftNeighbour = iter.next().getPoint();
            PointDoubleIndexed pointToCheck = iter.next().getPoint();
            while (iter.hasNext()) {
                PointDoubleIndexed rightNeighbour = iter.next().getPoint();
                if (GeometricFunctions.getDistanceBetweenLineAndPoint(leftNeighbour, rightNeighbour, pointToCheck) < 5.0) {
                    updateNecessary = true;
                    iter.previous();
                    iter.previous();
                    iter.remove();
                    pointToCheck = iter.next().getPoint();
                    continue;
                }
                leftNeighbour = pointToCheck;
                pointToCheck = rightNeighbour;
            }
        }
        if (updateNecessary) {
            this.rebuildpointIndexes();
        }
        return updateNecessary;
    }

    public List<Line> getRelationPointLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 1; i < this.points.size(); ++i) {
            lines.add(new Line(this.points.get(i - 1).getPoint(), this.points.get(i).getPoint()));
        }
        return lines;
    }

    public Line getFirstLine() {
        return new Line(this.points.get(0).getPoint(), this.points.get(1).getPoint());
    }

    public Line getMiddleLine() {
        PointDoubleIndexed begin = this.points.get(this.points.size() / 2).getPoint();
        PointDoubleIndexed end = this.points.get(this.points.size() / 2 - 1).getPoint();
        return new Line(begin, end);
    }

    public PointDouble getRelationCenter() {
        List<Line> lines = this.getRelationPointLines();
        double halfLength = this.getRelationHalfLength(lines);
        double currentLength = 0.0;
        PointDouble relationMiddlePoint = null;
        for (Line line : lines) {
            if (!(halfLength < (currentLength += line.getLength()))) continue;
            relationMiddlePoint = line.getPointOnLineWithDistanceFrom(false, currentLength - halfLength);
            break;
        }
        return relationMiddlePoint;
    }

    public Line getLastLine() {
        return new Line(this.points.get(this.points.size() - 2).getPoint(), this.points.get(this.points.size() - 1).getPoint());
    }

    public Collection<PointDoubleIndexed> getStickablePoints() {
        return Arrays.asList(this.points.get(0).getPoint(), this.points.get(this.points.size() - 1).getPoint());
    }

    public Rectangle getDragBox() {
        PointDouble center = this.getRelationCenter();
        double size = 6.0;
        Rectangle rectangle = new Rectangle(center.x - size, center.y - size, size * 2.0, size * 2.0);
        return rectangle;
    }

    public String toAdditionalAttributesString() {
        StringBuilder sb = new StringBuilder("");
        for (RelationPoint p : this.points) {
            sb.append(p.getPoint().getX()).append(";").append(p.getPoint().getY()).append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return "Relationpoints: " + SharedUtils.listToString(",", this.points);
    }

    public PointDoubleIndexed get(int index) {
        return this.points.get(index).getPoint();
    }

    public void setSize(int index, Rectangle size) {
        for (RelationPoint p : this.points) {
            if (p.getPoint().getIndex() != index) continue;
            p.setSize(size);
            return;
        }
        throw new RuntimeException("Unknown Point Index " + index);
    }

    public void setTextBox(int index, Rectangle rect) {
        Rectangle realignedRect = SharedUtils.realignToGrid(rect, true);
        this.textBoxSpaces.put(index, realignedRect);
    }

    public void removeTextBox(int index) {
        this.textBoxSpaces.remove(index);
    }

    public Set<Integer> getTextBoxIndexes() {
        return this.textBoxSpaces.keySet();
    }

    public Rectangle createRectangleContainingAllPointsAndTextSpace() {
        Rectangle rectangleContainingAllPointsAndTextSpace = null;
        for (RelationPoint p : this.points) {
            rectangleContainingAllPointsAndTextSpace = Rectangle.mergeToLeft(rectangleContainingAllPointsAndTextSpace, p.getSizeAbsolute());
        }
        for (Rectangle textSpace : this.textBoxSpaces.values()) {
            rectangleContainingAllPointsAndTextSpace = Rectangle.mergeToLeft(rectangleContainingAllPointsAndTextSpace, textSpace);
        }
        return rectangleContainingAllPointsAndTextSpace;
    }

    private double getRelationHalfLength(List<Line> lines) {
        double totalLength = 0.0;
        for (Line line : lines) {
            totalLength += line.getLength();
        }
        return totalLength / 2.0;
    }
}

