/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.sequence_aio.facet.Lifeline;
import com.baselet.element.sequence_aio.facet.LifelineOccurrence;

public class Coregion
implements LifelineOccurrence {
    private static final double COREGION_GAP_LIFELINE = 10.0;
    private static final double COREGION_HEIGHT = 10.0;
    private final Lifeline correspondingLifeline;
    private final int tick;
    private final boolean start;

    public Coregion(Lifeline lifeline, int tick, boolean start) {
        this.correspondingLifeline = lifeline;
        this.tick = tick;
        this.start = start;
    }

    @Override
    public Line1D draw(DrawHandler drawHandler, PointDouble topLeft, PointDouble size) {
        PointDouble topLeftCoregion = new PointDouble(topLeft.x + size.x / 2.0 - this.getWidth() / 2.0, topLeft.y + size.y / 2.0 - 5.0);
        if (this.isStart()) {
            drawHandler.drawLine(topLeftCoregion.x, topLeftCoregion.y, topLeftCoregion.x + this.getWidth(), topLeftCoregion.y);
        } else {
            drawHandler.drawLine(topLeftCoregion.x, topLeftCoregion.y + 10.0, topLeftCoregion.x + this.getWidth(), topLeftCoregion.y + 10.0);
        }
        drawHandler.drawLine(topLeftCoregion.x, topLeftCoregion.y, topLeftCoregion.x, topLeftCoregion.y + 10.0);
        drawHandler.drawLine(topLeftCoregion.x + this.getWidth(), topLeftCoregion.y, topLeftCoregion.x + this.getWidth(), topLeftCoregion.y + 10.0);
        return null;
    }

    @Override
    public double getMinWidth(DrawHandler drawHandler) {
        return this.getWidth();
    }

    public double getWidth() {
        return this.correspondingLifeline.getLifelineRightPartWidth(this.tick) * 2.0 + 20.0;
    }

    @Override
    public double getAdditionalYHeight(DrawHandler drawHandler, PointDouble size) {
        return 10.0 - size.y;
    }

    public boolean isStart() {
        return this.start;
    }
}

