/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.SortedMergedLine1DList;
import com.baselet.element.sequence_aio.facet.Container;
import com.baselet.element.sequence_aio.facet.DrawingInfo;
import com.baselet.element.sequence_aio.facet.HorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.Lifeline;
import com.baselet.element.sequence_aio.facet.LifelineDrawingInfo;
import com.baselet.element.sequence_aio.facet.LifelineHorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.VerticalDrawingInfo;

public class DrawingInfoImpl
implements DrawingInfo {
    private final HorizontalDrawingInfo horizontalDrawingInfo;
    private final SortedMergedLine1DList[] interruptedAreas;
    private final VerticalDrawingInfo verticalDrawingInfo;

    public DrawingInfoImpl(HorizontalDrawingInfo horizontalDrawingInfo, VerticalDrawingInfo verticalDrawingInfo, int lifelineCount) {
        this.horizontalDrawingInfo = horizontalDrawingInfo;
        this.interruptedAreas = new SortedMergedLine1DList[lifelineCount];
        for (int i = 0; i < this.interruptedAreas.length; ++i) {
            this.interruptedAreas[i] = new SortedMergedLine1DList();
        }
        this.verticalDrawingInfo = verticalDrawingInfo;
    }

    @Override
    public LifelineDrawingInfo getDrawingInfo(Lifeline lifeline) {
        return new LifelineDrawingInfoProxy(lifeline);
    }

    @Override
    public LifelineHorizontalDrawingInfo getHDrawingInfo(Lifeline lifeline) {
        return this.horizontalDrawingInfo.getHDrawingInfo(lifeline);
    }

    @Override
    public double getSymmetricWidth(Lifeline ll1, Lifeline ll2, int tick) {
        return this.horizontalDrawingInfo.getSymmetricWidth(ll1, ll2, tick);
    }

    @Override
    public double getHorizontalStart(Container container) {
        return this.horizontalDrawingInfo.getHorizontalStart(container);
    }

    @Override
    public double getHorizontalEnd(Container container) {
        return this.horizontalDrawingInfo.getHorizontalEnd(container);
    }

    @Override
    public double getWidth(Container container) {
        return this.horizontalDrawingInfo.getWidth(container);
    }

    @Override
    public double getDiagramHorizontalStart() {
        return this.horizontalDrawingInfo.getDiagramHorizontalStart();
    }

    @Override
    public double getDiagramHorizontalEnd() {
        return this.horizontalDrawingInfo.getDiagramHorizontalEnd();
    }

    @Override
    public double getDiagramWidth() {
        return this.horizontalDrawingInfo.getDiagramWidth();
    }

    private SortedMergedLine1DList getInterruptedAreas(int lifelineIndex) {
        return this.interruptedAreas[lifelineIndex];
    }

    @Override
    public double getVerticalHeadStart() {
        return this.verticalDrawingInfo.getVerticalHeadStart();
    }

    @Override
    public double getVerticalHeadEnd() {
        return this.verticalDrawingInfo.getVerticalHeadEnd();
    }

    @Override
    public double getHeadHeight() {
        return this.verticalDrawingInfo.getHeadHeight();
    }

    @Override
    public double getVerticalStart(int tick) {
        return this.verticalDrawingInfo.getVerticalStart(tick);
    }

    @Override
    public double getVerticalEnd(int tick) {
        return this.verticalDrawingInfo.getVerticalEnd(tick);
    }

    @Override
    public double getVerticalCenter(int tick) {
        return this.verticalDrawingInfo.getVerticalCenter(tick);
    }

    @Override
    public double getTickHeight(int tick) {
        return this.verticalDrawingInfo.getTickHeight(tick);
    }

    @Override
    public double getTickVerticalPadding() {
        return this.verticalDrawingInfo.getTickVerticalPadding();
    }

    @Override
    public double getVerticalStart(Container container) {
        return this.verticalDrawingInfo.getVerticalStart(container);
    }

    @Override
    public double getVerticalEnd(Container container) {
        return this.verticalDrawingInfo.getVerticalEnd(container);
    }

    private class LifelineDrawingInfoProxy
    implements LifelineDrawingInfo {
        private final Lifeline lifeline;

        public LifelineDrawingInfoProxy(Lifeline lifeline) {
            this.lifeline = lifeline;
        }

        @Override
        public double getHorizontalStart() {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getHorizontalStart();
        }

        @Override
        public double getHorizontalEnd() {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getHorizontalEnd();
        }

        @Override
        public double getHorizontalStart(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getHorizontalStart(tick);
        }

        @Override
        public double getHorizontalEnd(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getHorizontalEnd(tick);
        }

        @Override
        public double getHorizontalCenter() {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getHorizontalCenter();
        }

        @Override
        public double getWidth() {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getWidth();
        }

        @Override
        public double getWidth(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getWidth(tick);
        }

        @Override
        public double getSymmetricHorizontalStart(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getSymmetricHorizontalStart(tick);
        }

        @Override
        public double getSymmetricHorizontalEnd(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getSymmetricHorizontalEnd(tick);
        }

        @Override
        public double getSymmetricWidth(int tick) {
            return DrawingInfoImpl.this.getHDrawingInfo(this.lifeline).getSymmetricWidth(tick);
        }

        @Override
        public double getVerticalHeadStart() {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalHeadStart();
        }

        @Override
        public double getVerticalHeadEnd() {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalHeadEnd();
        }

        @Override
        public double getHeadHeight() {
            return DrawingInfoImpl.this.verticalDrawingInfo.getHeadHeight();
        }

        @Override
        public double getVerticalStart(int tick) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalStart(tick);
        }

        @Override
        public double getVerticalEnd(int tick) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalEnd(tick);
        }

        @Override
        public double getVerticalCenter(int tick) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalCenter(tick);
        }

        @Override
        public double getTickHeight(int tick) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getTickHeight(tick);
        }

        @Override
        public double getTickVerticalPadding() {
            return DrawingInfoImpl.this.verticalDrawingInfo.getTickVerticalPadding();
        }

        @Override
        public SortedMergedLine1DList getInterruptedAreas() {
            return DrawingInfoImpl.this.getInterruptedAreas(this.lifeline.getIndex());
        }

        @Override
        public void addInterruptedArea(Line1D llInterruption) {
            this.getInterruptedAreas().add(llInterruption);
        }

        @Override
        public double getVerticalStart(Container container) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalStart(container);
        }

        @Override
        public double getVerticalEnd(Container container) {
            return DrawingInfoImpl.this.verticalDrawingInfo.getVerticalStart(container);
        }
    }
}

