/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.element.sequence_aio.facet.Container;
import com.baselet.element.sequence_aio.facet.HorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.Lifeline;
import com.baselet.element.sequence_aio.facet.LifelineHorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.LifelineHorizontalDrawingInfoImpl;
import com.baselet.element.sequence_aio.facet.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.sequence_aio.facet.SequenceDiagram;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;

public class HorizontalDrawingInfoImpl
implements HorizontalDrawingInfo {
    private final double diagramStart;
    private final double diagramWidth;
    private final LifelineHorizontalDrawingInfo[] horizontalDrawingInfos;
    private final Map<Container, Double> containerLeftPadding;
    private final Map<Container, Double> containerRightPadding;

    public HorizontalDrawingInfoImpl(double diagramStart, double diagramMinWidth, SequenceDiagram.DoubleConverter widthConverter, double lifelineWidth, double lifelineXPadding, int lifelineCount, int lastTick, Collection<LifelineSpanningTickSpanningOccurrence.ContainerPadding> paddings) {
        this.containerLeftPadding = new HashMap<Container, Double>((int)((double)paddings.size() / 0.7));
        this.containerRightPadding = new HashMap<Container, Double>((int)((double)paddings.size() / 0.7));
        this.horizontalDrawingInfos = new LifelineHorizontalDrawingInfo[lifelineCount];
        this.diagramStart = diagramStart;
        double maxPadding = 0.0;
        double[][] leftPaddings = new double[lifelineCount][];
        double[][] rightPaddings = new double[lifelineCount][];
        for (int i = 0; i < lifelineCount; ++i) {
            PaddingInfo paddingInfo = this.getPaddings(i, true, lastTick, paddings);
            leftPaddings[i] = paddingInfo.paddings;
            maxPadding = Math.max(maxPadding, paddingInfo.maxPadding);
            paddingInfo = this.getPaddings(i, false, lastTick, paddings);
            rightPaddings[i] = paddingInfo.paddings;
            maxPadding = Math.max(maxPadding, paddingInfo.maxPadding);
        }
        double diagramWidth = (lifelineWidth += maxPadding * 2.0) * (double)lifelineCount + lifelineXPadding * (double)(lifelineCount + 1);
        if (diagramWidth < diagramMinWidth) {
            diagramWidth = diagramMinWidth;
            if (lifelineCount > 0) {
                lifelineWidth = (diagramWidth - lifelineXPadding * (double)(lifelineCount + 1)) / (double)lifelineCount;
            }
        }
        diagramWidth = widthConverter.convert(diagramWidth);
        double lifelineHeadLeftStart = (diagramWidth - (lifelineWidth * (double)lifelineCount + lifelineXPadding * (double)(lifelineCount - 1))) / 2.0;
        this.diagramWidth = diagramWidth;
        for (int i = 0; i < this.horizontalDrawingInfos.length; ++i) {
            this.horizontalDrawingInfos[i] = new LifelineHorizontalDrawingInfoImpl(leftPaddings[i], rightPaddings[i], lifelineHeadLeftStart + (lifelineWidth + lifelineXPadding) * (double)i, lifelineHeadLeftStart + (lifelineWidth + lifelineXPadding) * (double)i + lifelineWidth);
        }
    }

    private PaddingInfo getPaddings(int lifelineId, boolean left, int lastTick, Collection<LifelineSpanningTickSpanningOccurrence.ContainerPadding> allPaddings) {
        double[] lifelinePaddings = new double[lastTick + 2];
        PriorityQueue<LifelineSpanningTickSpanningOccurrence.ContainerPadding> paddingQueueStart = new PriorityQueue<LifelineSpanningTickSpanningOccurrence.ContainerPadding>(5, LifelineSpanningTickSpanningOccurrence.ContainerPadding.getContainerStartTickLifelineAscComparator());
        LinkedList paddingListEnd = new LinkedList();
        for (LifelineSpanningTickSpanningOccurrence.ContainerPadding cp : allPaddings) {
            if (left && cp.getContainer().getFirstLifeline().getIndex() == lifelineId && cp.getLeftPadding() > 0.0) {
                paddingQueueStart.add(cp);
                continue;
            }
            if (left || cp.getContainer().getLastLifeline().getIndex() != lifelineId || !(cp.getRightPadding() > 0.0)) continue;
            paddingQueueStart.add(cp);
        }
        double maxPadding = 0.0;
        for (int tick = 0; tick < lifelinePaddings.length; ++tick) {
            while (paddingQueueStart.peek() != null && ((LifelineSpanningTickSpanningOccurrence.ContainerPadding)paddingQueueStart.peek()).getContainer().getStartTick() == tick) {
                paddingListEnd.addLast(paddingQueueStart.poll());
            }
            Iterator endIter = paddingListEnd.iterator();
            while (endIter.hasNext()) {
                LifelineSpanningTickSpanningOccurrence.ContainerPadding paddingInterval = (LifelineSpanningTickSpanningOccurrence.ContainerPadding)endIter.next();
                if (left) {
                    if (!this.containerLeftPadding.containsKey(paddingInterval.getContainer())) {
                        this.containerLeftPadding.put(paddingInterval.getContainer(), lifelinePaddings[tick]);
                    }
                    int n = tick;
                    lifelinePaddings[n] = lifelinePaddings[n] + paddingInterval.getLeftPadding();
                } else {
                    if (!this.containerRightPadding.containsKey(paddingInterval.getContainer())) {
                        this.containerRightPadding.put(paddingInterval.getContainer(), lifelinePaddings[tick]);
                    }
                    int n = tick;
                    lifelinePaddings[n] = lifelinePaddings[n] + paddingInterval.getRightPadding();
                }
                if (paddingInterval.getContainer().getEndTick() != tick) continue;
                endIter.remove();
            }
            maxPadding = Math.max(maxPadding, lifelinePaddings[tick]);
        }
        return new PaddingInfo(lifelinePaddings, maxPadding);
    }

    @Override
    public LifelineHorizontalDrawingInfo getHDrawingInfo(Lifeline lifeline) {
        return this.horizontalDrawingInfos[lifeline.getIndex()];
    }

    @Override
    public double getSymmetricWidth(Lifeline ll1, Lifeline ll2, int tick) {
        if (ll1.getIndex() <= ll2.getIndex()) {
            return this.getHDrawingInfo(ll2).getSymmetricHorizontalEnd(tick) - this.getHDrawingInfo(ll1).getSymmetricHorizontalStart(tick);
        }
        return this.getHDrawingInfo(ll1).getSymmetricHorizontalEnd(tick) - this.getHDrawingInfo(ll2).getSymmetricHorizontalStart(tick);
    }

    @Override
    public double getHorizontalStart(Container container) {
        return this.getHDrawingInfo(container.getFirstLifeline()).getHorizontalStart() + this.containerLeftPadding.get(container);
    }

    @Override
    public double getHorizontalEnd(Container container) {
        return this.getHDrawingInfo(container.getLastLifeline()).getHorizontalEnd() - this.containerRightPadding.get(container);
    }

    @Override
    public double getWidth(Container container) {
        return this.getHorizontalEnd(container) - this.getHorizontalStart(container);
    }

    @Override
    public double getDiagramHorizontalStart() {
        return this.diagramStart;
    }

    @Override
    public double getDiagramHorizontalEnd() {
        return this.diagramStart + this.diagramWidth;
    }

    @Override
    public double getDiagramWidth() {
        return this.diagramWidth;
    }

    private static class PaddingInfo {
        private final double[] paddings;
        private final double maxPadding;

        public PaddingInfo(double[] paddings, double maxPadding) {
            this.paddings = paddings;
            this.maxPadding = maxPadding;
        }
    }
}

