/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.relation.helper.RelationDrawer;
import com.baselet.element.sequence_aio.facet.DrawingInfo;
import com.baselet.element.sequence_aio.facet.HorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.Lifeline;
import com.baselet.element.sequence_aio.facet.LifelineHorizontalDrawingInfo;
import com.baselet.element.sequence_aio.facet.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.sequence_aio.facet.OccurrenceSpecification;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements LifelineSpanningTickSpanningOccurrence {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    protected static final double LIFELINE_TEXT_PADDING = 16.0;
    protected static final double SELF_MESSAGE_LIFELINE_GAP = 20.0;
    protected static final double SELF_MESSAGE_TEXT_PADDING = 5.0;
    protected final Lifeline from;
    protected final Lifeline to;
    protected final int duration;
    protected final int sendTick;
    protected final String[] textLines;
    protected final ArrowType arrowType;
    protected final LineType lineType;

    public Message(Lifeline from, Lifeline to, int duration, int sendTick, String text, ArrowType arrowType, LineType lineType) {
        this.from = from;
        this.to = to;
        this.duration = duration;
        this.sendTick = sendTick;
        this.textLines = text.split("\n");
        this.arrowType = arrowType;
        this.lineType = lineType;
    }

    @Override
    public Lifeline getFirstLifeline() {
        return this.from.getIndex() < this.to.getIndex() ? this.from : this.to;
    }

    @Override
    public Lifeline getLastLifeline() {
        return this.from.getIndex() > this.to.getIndex() ? this.from : this.to;
    }

    protected double getSendCenterXOffset() {
        if (this.from == this.to) {
            return this.from.getLifelineRightPartWidth(this.sendTick);
        }
        if (this.getFirstLifeline() == this.from) {
            return this.from.getLifelineRightPartWidth(this.sendTick);
        }
        return -this.from.getLifelineLeftPartWidth(this.sendTick);
    }

    protected double getReceiveCenterXOffset() {
        if (this.from == this.to) {
            return this.to.getLifelineRightPartWidth(this.sendTick + this.duration);
        }
        if (this.getFirstLifeline() == this.from) {
            return -this.to.getLifelineLeftPartWidth(this.sendTick + this.duration);
        }
        return this.to.getLifelineRightPartWidth(this.sendTick + this.duration);
    }

    protected double getSendX(HorizontalDrawingInfo hDrawingInfo) {
        return hDrawingInfo.getHDrawingInfo(this.from).getHorizontalCenter() + this.getSendCenterXOffset();
    }

    protected double getReceiveX(HorizontalDrawingInfo hDrawingInfo) {
        LifelineHorizontalDrawingInfo llHDrawingInfo = hDrawingInfo.getHDrawingInfo(this.to);
        double receiveX = llHDrawingInfo.getHorizontalCenter();
        receiveX += this.getReceiveCenterXOffset();
        if (!this.to.isCreatedOnStart() && this.to.getCreated() != null && this.sendTick + this.duration == this.to.getCreated()) {
            receiveX = this.getFirstLifeline() == this.to ? llHDrawingInfo.getSymmetricHorizontalEnd(this.sendTick + this.duration) : llHDrawingInfo.getSymmetricHorizontalStart(this.sendTick + this.duration);
        }
        return receiveX;
    }

    @Override
    public void draw(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        PointDouble send = new PointDouble(this.getSendX(drawingInfo), drawingInfo.getVerticalCenter(this.sendTick));
        PointDouble receive = new PointDouble(this.getReceiveX(drawingInfo), drawingInfo.getVerticalCenter(this.sendTick + this.duration));
        RelationDrawer.ArrowEndType arrowEndType = RelationDrawer.ArrowEndType.NORMAL;
        boolean fillArrow = false;
        switch (this.arrowType) {
            case OPEN: {
                arrowEndType = RelationDrawer.ArrowEndType.NORMAL;
                fillArrow = false;
                break;
            }
            case FILLED: {
                arrowEndType = RelationDrawer.ArrowEndType.CLOSED;
                fillArrow = true;
                break;
            }
            default: {
                log.error("Encountered unhandled enumeration value '" + (Object)((Object)this.arrowType) + "'.");
            }
        }
        LineType oldLt = drawHandler.getLineType();
        drawHandler.setLineType(this.lineType);
        if (this.from == this.to) {
            this.drawSelfMessage(drawHandler, send, receive, arrowEndType, fillArrow, drawingInfo);
        } else {
            this.drawNormalMessage(drawHandler, send, receive, arrowEndType, fillArrow, drawingInfo);
        }
        drawHandler.setLineType(oldLt);
    }

    protected void drawNormalMessage(DrawHandler drawHandler, PointDouble send, PointDouble receive, RelationDrawer.ArrowEndType arrowEndType, boolean fillArrow, DrawingInfo drawingInfo) {
        AlignHorizontal hAlignment;
        double topLeftX;
        Line line = new Line(send, receive);
        drawHandler.drawLine(line);
        drawHandler.setLineType(LineType.SOLID);
        RelationDrawer.drawArrowToLine(receive, drawHandler, line, false, arrowEndType, fillArrow, false);
        double height = send.y - drawingInfo.getVerticalStart(this.sendTick);
        if (this.from == this.getFirstLifeline()) {
            topLeftX = send.x;
            hAlignment = AlignHorizontal.LEFT;
        } else {
            topLeftX = receive.x;
            hAlignment = AlignHorizontal.RIGHT;
        }
        if (this.duration == 0) {
            hAlignment = AlignHorizontal.CENTER;
        }
        TextSplitter.drawText(drawHandler, this.textLines, topLeftX += 16.0, send.y - height, Math.abs(send.x - receive.x) - 32.0, height, hAlignment, AlignVertical.BOTTOM);
    }

    protected void drawSelfMessage(DrawHandler drawHandler, PointDouble send, PointDouble receive, RelationDrawer.ArrowEndType arrowEndType, boolean fillArrow, DrawingInfo hInfo) {
        double rightBorderX = Math.max(send.x, receive.x) + 20.0;
        PointDouble[] msgLine = new PointDouble[]{send, new PointDouble(rightBorderX, send.y), new PointDouble(rightBorderX, receive.y), receive};
        drawHandler.drawLines(msgLine);
        drawHandler.setLineType(LineType.SOLID);
        RelationDrawer.drawArrowToLine(receive, drawHandler, new Line(msgLine[2], msgLine[3]), false, arrowEndType, fillArrow, false);
        double lifelineXEnd = Math.min(hInfo.getHDrawingInfo(this.to).getSymmetricHorizontalEnd(this.sendTick), hInfo.getHDrawingInfo(this.to).getSymmetricHorizontalEnd(this.sendTick + this.duration));
        TextSplitter.drawText(drawHandler, this.textLines, rightBorderX += 5.0, send.y, lifelineXEnd - rightBorderX, receive.y - send.y, AlignHorizontal.LEFT, AlignVertical.CENTER);
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        if (this.from == this.to) {
            return this.getOverallMinWidthSelfMessage(drawHandler, lifelineHorizontalPadding);
        }
        return this.getOverallMinWidthNormalMessage(drawHandler, lifelineHorizontalPadding);
    }

    protected double getOverallMinWidthSelfMessage(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        double executionSpecWidth = Math.max(this.from.getLifelineRightPartWidth(this.sendTick), this.to.getLifelineRightPartWidth(this.sendTick + this.duration));
        return (executionSpecWidth + 20.0 + 5.0 + TextSplitter.getTextMinWidth(this.textLines, drawHandler)) * 2.0;
    }

    protected double getOverallMinWidthNormalMessage(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        double executionSpecWidth = Math.abs(this.getSendCenterXOffset()) + Math.abs(this.getReceiveCenterXOffset());
        double neededWidth = executionSpecWidth + TextSplitter.getTextMinWidth(this.textLines, drawHandler) + 32.0;
        int affectedLifelineCount = this.getLastLifeline().getIndex() - this.getFirstLifeline().getIndex() + 1;
        if (!this.to.isCreatedOnStart() && this.to.getCreated() != null && this.to.getCreated() == this.sendTick + this.duration) {
            return ((double)(2 * affectedLifelineCount) * neededWidth - (double)(3 * (affectedLifelineCount - 1)) * lifelineHorizontalPadding) / (double)(2 * affectedLifelineCount - 3);
        }
        return neededWidth / (double)(affectedLifelineCount - 1) * (double)affectedLifelineCount - lifelineHorizontalPadding;
    }

    @Override
    public Map<Integer, Double> getEveryAdditionalYHeight(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight) {
        HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        if (this.from == this.to) {
            this.getEveryAdditionalYHeightSelfMessage(drawHandler, hInfo, defaultTickHeight, ret);
        } else {
            this.getEveryAdditionalYHeightNormalMessage(drawHandler, hInfo, defaultTickHeight, ret);
        }
        return ret;
    }

    protected void getEveryAdditionalYHeightNormalMessage(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight, Map<Integer, Double> ret) {
        double maxTextWidth = Math.abs(this.getSendX(hInfo) - this.getReceiveX(hInfo));
        double additionalHeight = TextSplitter.getSplitStringHeight(this.textLines, maxTextWidth -= 32.0, drawHandler);
        additionalHeight -= defaultTickHeight / 2.0;
        if ((additionalHeight *= 2.0) > 0.0) {
            ret.put(this.sendTick, additionalHeight);
        }
    }

    protected void getEveryAdditionalYHeightSelfMessage(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight, Map<Integer, Double> ret) {
        double executionSpecWidth = Math.max(this.from.getLifelineRightPartWidth(this.sendTick), this.to.getLifelineRightPartWidth(this.sendTick + this.duration));
        double maxTextWidth = Math.min(hInfo.getHDrawingInfo(this.to).getSymmetricWidth(this.sendTick), hInfo.getHDrawingInfo(this.to).getSymmetricWidth(this.sendTick + this.duration)) / 2.0;
        double additionalHeight = TextSplitter.getSplitStringHeight(this.textLines, maxTextWidth -= executionSpecWidth + 20.0 + 5.0, drawHandler) - (double)this.duration * defaultTickHeight;
        if (additionalHeight > 0.0) {
            for (int i = this.sendTick + 1; i < this.sendTick + this.duration; ++i) {
                ret.put(i, additionalHeight / (double)this.duration);
            }
            ret.put(this.sendTick, additionalHeight / (double)this.duration);
            ret.put(this.sendTick + this.duration, additionalHeight / (double)this.duration);
        }
    }

    @Override
    public LifelineSpanningTickSpanningOccurrence.ContainerPadding getPaddingInformation() {
        return null;
    }

    public OccurrenceSpecification sendOccurrenceSpecification() {
        return new MessageSendEndpoint();
    }

    public OccurrenceSpecification receiveOccurrenceSpecification() {
        return new MessageReceiveEndpoint();
    }

    private class MessageReceiveEndpoint
    implements OccurrenceSpecification {
        private MessageReceiveEndpoint() {
        }

        @Override
        public boolean hasFixedPosition() {
            return true;
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo, boolean left) {
            return new PointDouble(0.0, 0.0);
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo) {
            return new PointDouble(this.getHorizonatlPosition(drawingInfo), drawingInfo.getVerticalCenter(Message.this.sendTick + Message.this.duration));
        }

        @Override
        public Lifeline getLifeline() {
            return Message.this.to;
        }

        @Override
        public double getHorizontalPosition(HorizontalDrawingInfo hDrawingInfo, boolean left) {
            return 0.0;
        }

        @Override
        public double getHorizonatlPosition(HorizontalDrawingInfo hDrawingInfo) {
            return Message.this.getReceiveX(hDrawingInfo);
        }

        @Override
        public AlignHorizontal getFixedPositionAlignment() {
            if (Message.this.from == Message.this.to) {
                return AlignHorizontal.RIGHT;
            }
            if (Message.this.from.getIndex() < Message.this.to.getIndex()) {
                return AlignHorizontal.RIGHT;
            }
            return AlignHorizontal.LEFT;
        }
    }

    private class MessageSendEndpoint
    implements OccurrenceSpecification {
        private MessageSendEndpoint() {
        }

        @Override
        public boolean hasFixedPosition() {
            return true;
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo, boolean left) {
            return new PointDouble(0.0, 0.0);
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo) {
            return new PointDouble(this.getHorizonatlPosition(drawingInfo), drawingInfo.getVerticalCenter(Message.this.sendTick));
        }

        @Override
        public Lifeline getLifeline() {
            return Message.this.from;
        }

        @Override
        public double getHorizontalPosition(HorizontalDrawingInfo hDrawingInfo, boolean left) {
            return 0.0;
        }

        @Override
        public double getHorizonatlPosition(HorizontalDrawingInfo hDrawingInfo) {
            return Message.this.getSendX(hDrawingInfo);
        }

        @Override
        public AlignHorizontal getFixedPositionAlignment() {
            if (Message.this.from == Message.this.to) {
                return AlignHorizontal.RIGHT;
            }
            if (Message.this.from.getIndex() < Message.this.to.getIndex()) {
                return AlignHorizontal.RIGHT;
            }
            return AlignHorizontal.LEFT;
        }
    }

    public static enum ArrowType {
        OPEN,
        FILLED;

    }
}

