/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import java.util.Collection;
import java.util.Collections;

public class PentagonDrawingHelper {
    private static final double HEADER_PENTAGON_SLOPE_WIDTH = 20.0;
    private static final double HEADER_PENTAGON_SLOPE_HEIGHT_PERCENTAGE = 0.4;
    private static final double HEADER_MIN_RIGHT_BORDER_GAP = 40.0;
    private static final double HEADER_TEXT_X_PADDING = 5.0;
    private static final double HEADER_TEXT_Y_PADDING = 3.0;

    private static double getStaticWidthPadding() {
        return 70.0;
    }

    private static double getStaticHeightPadding() {
        return 6.0;
    }

    public static double getMinimumWidth(DrawHandler drawHandler, String[] textLines) {
        return TextSplitter.getTextMinWidth(textLines, drawHandler) + PentagonDrawingHelper.getStaticWidthPadding();
    }

    public static double getPentagonMinimumWidth(DrawHandler drawHandler, String[] textLines) {
        return TextSplitter.getTextMinWidth(textLines, drawHandler) + PentagonDrawingHelper.getStaticWidthPadding() - 40.0;
    }

    public static double getHeight(DrawHandler drawHandler, String[] textLines, double width) {
        return TextSplitter.getSplitStringHeight(textLines, width - PentagonDrawingHelper.getStaticWidthPadding(), drawHandler) + PentagonDrawingHelper.getStaticHeightPadding();
    }

    public static PointDouble draw(DrawHandler drawHandler, String[] textLines, double width, PointDouble topLeft) {
        return PentagonDrawingHelper.draw(drawHandler, textLines, width, topLeft, Collections.<Line1D>emptyList());
    }

    public static PointDouble draw(DrawHandler drawHandler, String[] textLines, double width, PointDouble topLeft, Collection<Line1D> slopeNotPermittedAreas) {
        boolean splitIsNecessary = false;
        double textWidth = width - PentagonDrawingHelper.getStaticWidthPadding();
        for (String l : textLines) {
            if (TextSplitter.splitStringAlgorithm(l, textWidth, drawHandler).length <= 1) continue;
            splitIsNecessary = true;
            break;
        }
        double height = PentagonDrawingHelper.getHeight(drawHandler, textLines, width);
        if (!splitIsNecessary) {
            textWidth = 0.0;
            for (String l : textLines) {
                textWidth = Math.max(textWidth, drawHandler.textWidth(l));
            }
            textWidth += drawHandler.textWidth("n");
        }
        TextSplitter.drawText(drawHandler, textLines, topLeft.x + 5.0, topLeft.y, textWidth, height, AlignHorizontal.LEFT, AlignVertical.CENTER);
        LineType oldLt = drawHandler.getLineType();
        drawHandler.setLineType(LineType.SOLID);
        double slopeStartX = topLeft.x + textWidth + 10.0;
        double slopeEndX = slopeStartX + 20.0;
        for (Line1D line : slopeNotPermittedAreas) {
            if (line.getLow() > slopeEndX) break;
            if (!line.isIntersecting(new Line1D(slopeStartX, slopeEndX))) continue;
            slopeStartX = line.getHigh();
            slopeEndX = slopeStartX + 20.0;
            break;
        }
        drawHandler.drawLines(new PointDouble(topLeft.x, topLeft.y + height), new PointDouble(slopeStartX, topLeft.y + height), new PointDouble(slopeEndX, topLeft.y + height * 0.6), new PointDouble(slopeEndX, topLeft.y));
        drawHandler.setLineType(oldLt);
        return new PointDouble(slopeEndX - topLeft.x, height);
    }
}

