/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sequence_aio.facet;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.sequence_aio.facet.SequenceDiagram;
import com.baselet.element.sequence_aio.facet.SequenceDiagramException;
import com.baselet.element.sequence_aio.facet.specific.gen.ParseException;
import com.baselet.element.sequence_aio.facet.specific.gen.SequenceAllInOneParser;
import com.baselet.element.sequence_aio.facet.specific.gen.TokenMgrException;
import com.baselet.gui.AutocompletionText;
import java.util.Arrays;
import java.util.List;

public class SequenceAllInOneFacet
extends Facet {
    public static final SequenceAllInOneFacet INSTANCE = new SequenceAllInOneFacet();

    private SequenceAllInOneFacet() {
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return true;
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText("title=", "Title of the sequence diagram"), new AutocompletionText("desc=", "Additional text, e.g. for local variables"), new AutocompletionText("autoTick=true", "(Default) Each line with an command is placed at a new time tick."), new AutocompletionText("autoTick=false", "Advancements down the time have to specified manually with the tick= command."), new AutocompletionText("overrideIds=true", "Each lifeline needs a explicit id."), new AutocompletionText("overrideIds=false", "(Default) each lifeline has a default id idX. X is a number starting at 1 and is increased from left to right."), new AutocompletionText("obj=New lifeline~", "Declares a new Lifeline"), new AutocompletionText("tick=", "Advances down the timeline"), new AutocompletionText("on=", "Starts a new execution specification on the given lifelines."), new AutocompletionText("off=", "Ends a existing execution specification on the given lifelines."), new AutocompletionText("ref=", ""), new AutocompletionText("continuation=", ""), new AutocompletionText("invariant=", ""), new AutocompletionText("stateInvariant=", ""), new AutocompletionText("coregionStart=", ""), new AutocompletionText("coregionEnd=", ""), new AutocompletionText("combinedFragment=", ""), new AutocompletionText("constraint=", "Specifies a constrain for an operand."), new AutocompletionText("destroy=", "Destroys a lifeline"), new AutocompletionText("lost", "Pseudo id for lost messages."), new AutocompletionText("found", "Pseudo id for found messages."), new AutocompletionText("gate", "Pseudo id for gate messages."), new AutocompletionText("ACTIVE", "Creates an active class as head for the lifeline."), new AutocompletionText("ACTOR", "The Lifeline head is an actor."), new AutocompletionText("CREATED_LATER", "The lifeline is created later with the first received message."), new AutocompletionText("EXECUTION", "The Lifeline has an active execution specification at the start."));
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        DrawHandler drawer = state.getDrawer();
        StringBuilder strBuilder = new StringBuilder();
        for (String str : handledLines) {
            strBuilder.append(str);
            strBuilder.append('\n');
        }
        try {
            SequenceDiagram.DoubleConverter gridConverter = new SequenceDiagram.DoubleConverter(){

                @Override
                public double convert(double value) {
                    return SharedUtils.realignToGrid(false, value, true);
                }
            };
            DimensionDouble size = new SequenceAllInOneParser(strBuilder.toString()).start().generateDiagram().draw(drawer, gridConverter, gridConverter);
            state.updateMinimumSize(size.getWidth(), size.getHeight());
        }
        catch (ParseException e) {
            throw new SequenceDiagramException(e);
        }
        catch (TokenMgrException e) {
            throw new SequenceDiagramException(e);
        }
    }
}

