/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.standalone;

import com.baselet.control.Main;
import com.baselet.control.config.Config;
import com.baselet.control.config.handler.ConfigHandler;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.Path;
import com.baselet.control.util.RunningFileChecker;
import com.baselet.control.util.Utils;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.UpdateCheckTimerTask;
import com.baselet.generator.ClassDiagramConverter;
import com.baselet.standalone.gui.StandaloneGUI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainStandalone {
    private static final Logger log = LoggerFactory.getLogger(MainStandalone.class);

    public static void main(String[] args) {
        System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        if (args.length != 0) {
            String actionArg = null;
            String formatArg = null;
            String filenameArg = null;
            String outputArg = null;
            for (String arg : args) {
                if (arg.equals("-help") || arg.equals("-usage")) {
                    MainStandalone.initAndPrintUsage();
                    return;
                }
                if (arg.startsWith("-action=")) {
                    actionArg = arg.substring(8);
                    continue;
                }
                if (arg.startsWith("-format=")) {
                    formatArg = arg.substring(8);
                    continue;
                }
                if (arg.startsWith("-filename=")) {
                    filenameArg = arg.substring(10);
                    continue;
                }
                if (!arg.startsWith("-output=")) continue;
                outputArg = arg.substring(8);
            }
            if (actionArg == null && formatArg == null && (filenameArg != null || args.length == 1)) {
                if (filenameArg == null) {
                    filenameArg = args[0];
                }
                MainStandalone.initAll(RuntimeType.STANDALONE);
                if (!MainStandalone.alreadyRunningChecker(false) || !MainStandalone.sendFileNameToRunningApplication(filenameArg)) {
                    MainStandalone.startStandalone(filenameArg);
                }
            } else if (actionArg != null && formatArg != null && filenameArg != null) {
                if (actionArg.equals("convert")) {
                    WildcardFileFilter fileFilter;
                    File[] files;
                    MainStandalone.initAll(RuntimeType.BATCH);
                    String[] splitFilename = filenameArg.split("(/|\\\\)");
                    String localName = splitFilename[splitFilename.length - 1];
                    String dir = filenameArg.substring(0, filenameArg.length() - localName.length());
                    if (dir.isEmpty()) {
                        dir = ".";
                    }
                    if ((files = new File(dir).listFiles(fileFilter = new WildcardFileFilter(localName))) != null) {
                        for (File file : files) {
                            log.info("Converting file " + file.getAbsolutePath());
                            MainStandalone.doConvert(file, formatArg, outputArg);
                        }
                    }
                } else {
                    MainStandalone.initAndPrintUsage();
                }
            } else if (actionArg != null && filenameArg != null && outputArg != null) {
                if (actionArg.equals("generate")) {
                    String[] inputPathNames;
                    MainStandalone.initAll(RuntimeType.BATCH);
                    String[] outputPathNameSplitted = outputArg.split("(/|\\\\)");
                    String outputFileName = outputPathNameSplitted[outputPathNameSplitted.length - 1];
                    String outputDirName = outputArg.substring(0, outputArg.length() - outputFileName.length());
                    File outputPath = new File(outputDirName + '\\' + outputFileName);
                    File outputDir = new File(outputDirName);
                    if (!outputDir.exists() && outputDir.mkdirs()) {
                        log.debug("created output dir");
                    }
                    ArrayList<File> inputPaths = new ArrayList<File>();
                    for (String inputpathName : inputPathNames = filenameArg.split(",")) {
                        WildcardFileFilter fileFilter;
                        File[] subInputPaths;
                        String[] inputpathNameSplitted = inputpathName.split("(/|\\\\)");
                        String inputFileName = inputpathNameSplitted[inputpathNameSplitted.length - 1];
                        String inputDirName = inputpathName.substring(0, inputpathName.length() - inputFileName.length());
                        if (inputDirName.isEmpty()) {
                            inputDirName = ".";
                        }
                        if ((subInputPaths = new File(inputDirName).listFiles(fileFilter = new WildcardFileFilter(inputFileName))) == null) continue;
                        for (File subInputPath : subInputPaths) {
                            inputPaths.add(subInputPath);
                        }
                    }
                    MainStandalone.doGenerate(inputPaths, outputPath);
                } else {
                    MainStandalone.initAndPrintUsage();
                }
            } else {
                MainStandalone.initAndPrintUsage();
            }
        } else {
            MainStandalone.initAll(RuntimeType.STANDALONE);
            MainStandalone.alreadyRunningChecker(true);
            MainStandalone.startStandalone(null);
        }
    }

    private static void initAndPrintUsage() {
        MainStandalone.readBuildInfoAndInitVersion(RuntimeType.BATCH);
        MainStandalone.printUsage();
    }

    private static void initAll(RuntimeType runtime) {
        MainStandalone.readBuildInfoAndInitVersion(runtime);
        MainStandalone.initHomeProgramPath();
        ConfigHandler.loadConfig();
    }

    private static void startStandalone(String filenameToOpen) {
        if (Config.getInstance().isCheckForUpdates()) {
            new Timer("Update Checker", true).schedule((TimerTask)UpdateCheckTimerTask.getInstance(), 0L);
        }
        Main.getInstance().init(new StandaloneGUI(Main.getInstance(), MainStandalone.tmpFile()));
        if (filenameToOpen == null) {
            Main.getInstance().doNew();
        } else {
            Main.getInstance().doOpen(filenameToOpen);
        }
    }

    static void doConvert(File inputFile, String outputFormat, String outputParam) {
        if (!inputFile.exists()) {
            MainStandalone.printToConsole("File '" + inputFile.getAbsolutePath() + "' not found.");
            return;
        }
        DiagramHandler handler = new DiagramHandler(inputFile);
        String outputFileName = MainStandalone.determineOutputName(inputFile, outputFormat, outputParam);
        try {
            handler.getFileHandler().doExportAs(outputFormat, new File(outputFileName));
            MainStandalone.printToConsole("Conversion finished: \"" + inputFile.getAbsolutePath() + "\" to \"" + outputFileName + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void doGenerate(List<File> inputFiles, File outputFile) {
        ArrayList<String> validInputFileNames = new ArrayList<String>();
        for (File inputFile : inputFiles) {
            if (!inputFile.exists()) {
                MainStandalone.printToConsole("File '" + inputFile.getAbsolutePath() + "' not found.");
                continue;
            }
            validInputFileNames.add(inputFile.getAbsolutePath());
        }
        try {
            FileOutputStream fos = null;
            try {
                String program = Program.getInstance().getProgramName().toLowerCase();
                String version = String.valueOf(Program.getInstance().getVersion());
                String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><diagram program=\"" + program + "\" version=\"" + version + "\"></diagram>";
                fos = new FileOutputStream(outputFile);
                fos.write(content.getBytes("UTF-8"));
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fos != null) {
                    fos.close();
                }
                return;
            }
            DiagramHandler handler = new DiagramHandler(outputFile);
            CurrentDiagram.getInstance().setCurrentDiagramHandler(handler);
            new ClassDiagramConverter().createClassDiagrams(validInputFileNames);
            handler.doSave();
            MainStandalone.printToConsole("Generation finished: \"" + validInputFileNames + "\" to \"" + outputFile.getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printToConsole(String text) {
        System.out.println(text);
    }

    private static String determineOutputName(File inputFile, String outputFormat, String outputParam) {
        String outputFileName = outputParam == null ? inputFile.getAbsolutePath() : (new File(outputParam).isDirectory() ? outputParam + File.separator + inputFile.getName() : outputParam);
        return MainStandalone.createBatchOutputName(outputFormat, outputFileName);
    }

    private static String createBatchOutputName(String extension, String fileName) {
        String uxf = "." + Program.getInstance().getExtension();
        if (fileName.endsWith(uxf)) {
            fileName = fileName.substring(0, fileName.length() - uxf.length());
        }
        if (fileName.endsWith(extension)) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    private static void initHomeProgramPath() {
        String tempPath = Path.executable();
        tempPath = tempPath.substring(0, tempPath.length() - 1);
        if ((tempPath = tempPath.substring(0, tempPath.lastIndexOf(47) + 1)).endsWith("/lib/")) {
            tempPath = tempPath.substring(0, tempPath.length() - "lib/".length());
        }
        String realPath = new File(tempPath).getAbsolutePath() + "/";
        Path.setHomeProgram(realPath);
    }

    private static boolean sendFileNameToRunningApplication(String filename) {
        File f1 = MainStandalone.tmpFile();
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f1), "UTF-8"));
            writer.println(filename);
            writer.close();
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private static boolean alreadyRunningChecker(boolean force) {
        try {
            File f = MainStandalone.tmpFile();
            if (f.exists() && !force) {
                return true;
            }
            Path.safeCreateFile(f, false);
            new Timer("alreadyRunningChecker", true).schedule((TimerTask)new RunningFileChecker(MainStandalone.tmpFile(), Main.getInstance()), 0L, 1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        return false;
    }

    private static File tmpFile() {
        String userPart = System.getProperty("user.name").replaceAll("[^a-zA-Z0-9\\._]+", "_");
        return new File(Path.temp() + Program.getInstance().getProgramName().toLowerCase() + "-" + userPart + ".tmp");
    }

    public static void readBuildInfoAndInitVersion(RuntimeType runtime) {
        Utils.BuildInfo buildInfo = Utils.readBuildInfo();
        Program.init(buildInfo.version, runtime);
    }

    private static void printUsage() {
        StringBuilder formatBuilder = new StringBuilder("pdf|svg|eps");
        for (String format : ImageIO.getWriterFileSuffixes()) {
            formatBuilder.append("|").append(format);
        }
        MainStandalone.printToConsole("USAGE FOR CONVERTING: -action=convert -format=(" + formatBuilder.toString() + ") -filename=inputfile." + Program.getInstance().getExtension() + " [-output=outputfile[.extension]]");
        MainStandalone.printToConsole("USAGE FOR GENERATING: -action=generate -filename=inputfile.java[,*.java] -output=outputfile." + Program.getInstance().getExtension());
    }
}

