/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.standalone.gui;

import com.baselet.control.config.Config;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.gui.BaseGUIBuilder;
import com.baselet.gui.filedrop.FileDrop;
import com.baselet.gui.filedrop.FileDropListener;
import com.baselet.gui.listener.GUIListener;
import com.baselet.gui.listener.UmletWindowFocusListener;
import com.baselet.standalone.gui.MenuBuilder;
import com.baselet.standalone.gui.SearchKeyListener;
import com.baselet.standalone.gui.SearchListener;
import com.baselet.standalone.gui.SwingWindowListener;
import com.baselet.standalone.gui.ZoomListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;

public class StandaloneGUIBuilder
extends BaseGUIBuilder {
    private JComboBox zoomComboBox;
    private ZoomListener zoomListener;
    private JTextField searchField;
    private JTabbedPane diagramtabs;
    private JToggleButton mailButton;

    public JTabbedPane getDiagramtabs() {
        return this.diagramtabs;
    }

    public JComboBox getZoomComboBox() {
        return this.zoomComboBox;
    }

    public ZoomListener getZoomListener() {
        return this.zoomListener;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public JFrame initSwingGui(MenuBuilder menuBuilder) {
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowFocusListener(new UmletWindowFocusListener());
        mainFrame.addKeyListener(new GUIListener());
        mainFrame.addKeyListener(new SearchKeyListener());
        mainFrame.addWindowListener(new SwingWindowListener());
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.setBounds(Config.getInstance().getProgram_location().x, Config.getInstance().getProgram_location().y, Config.getInstance().getProgram_size().width, Config.getInstance().getProgram_size().height);
        mainFrame.setTitle(Program.getInstance().getProgramName() + " - Free UML Tool for Fast UML Diagrams");
        this.setImage(mainFrame);
        if (Config.getInstance().isStart_maximized()) {
            mainFrame.setExtendedState(mainFrame.getExtendedState() | 6);
            mainFrame.setVisible(true);
        }
        mainFrame.setJMenuBar(menuBuilder.createMenu(this.createSearchPanel(), this.createZoomPanel(), this.createMailButton()));
        JPanel diagramTabPanel = this.createDiagramTabPanel();
        int mainDividerLoc = Math.min(mainFrame.getSize().width - 100, Config.getInstance().getMain_split_position());
        JSplitPane baseSplitPane = this.initBase(diagramTabPanel, mainDividerLoc);
        mainFrame.add(baseSplitPane);
        ToolTipManager.sharedInstance().setInitialDelay(100);
        mainFrame.setVisible(true);
        return mainFrame;
    }

    private void setImage(JFrame mainFrame) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        int[] nArray = new int[]{16, 20, 24, 32, 40, 48, 64};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            InputStream is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream(Program.getInstance().getProgramName().toLowerCase() + "_logo" + i2 + ".png");
                images.add(ImageIO.read(is));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read image", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        mainFrame.setIconImages(images);
    }

    private void createZoomComboBox() {
        this.zoomComboBox = new JComboBox();
        this.zoomComboBox.setPreferredSize(new Dimension(80, 24));
        this.zoomComboBox.setMinimumSize(this.zoomComboBox.getPreferredSize());
        this.zoomComboBox.setMaximumSize(this.zoomComboBox.getPreferredSize());
        this.zoomListener = new ZoomListener();
        this.zoomComboBox.addActionListener(this.zoomListener);
        this.zoomComboBox.addMouseWheelListener(this.zoomListener);
        this.zoomComboBox.setToolTipText("Use \u00b1 or mouse wheel to zoom");
        String[] zoomValues = Constants.zoomValueList.toArray(new String[Constants.zoomValueList.size()]);
        this.zoomComboBox.setModel(new DefaultComboBoxModel<String>(zoomValues));
        this.zoomComboBox.setSelectedIndex(9);
    }

    public JPanel createZoomPanel() {
        this.createZoomComboBox();
        JPanel zoomPanel = new JPanel();
        zoomPanel.setOpaque(false);
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 0));
        zoomPanel.add(new JLabel("Zoom:   "));
        zoomPanel.add(this.zoomComboBox);
        zoomPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        return zoomPanel;
    }

    private void createSearchField() {
        this.searchField = new JTextField(10);
        this.searchField.setMinimumSize(this.searchField.getPreferredSize());
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        this.searchField.addKeyListener(new SearchListener());
    }

    public JPanel createSearchPanel() {
        this.createSearchField();
        JPanel searchPanel = new JPanel();
        searchPanel.setOpaque(false);
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        searchPanel.add(new JLabel("Search:   "));
        searchPanel.add(this.searchField);
        searchPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        return searchPanel;
    }

    public JPanel createDiagramTabPanel() {
        JPanel diagramspanel = new JPanel();
        new FileDrop(diagramspanel, new FileDropListener());
        this.diagramtabs = new JTabbedPane();
        this.diagramtabs.setTabLayoutPolicy(1);
        diagramspanel.setLayout(new GridLayout(1, 1));
        diagramspanel.add(this.diagramtabs);
        return diagramspanel;
    }

    public JToggleButton createMailButton() {
        this.mailButton = new JToggleButton("Mail diagram");
        this.mailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandaloneGUIBuilder.this.setMailPanelEnabled(!StandaloneGUIBuilder.this.getMailPanel().isVisible());
            }
        });
        return this.mailButton;
    }

    @Override
    public void setMailPanelEnabled(boolean enable) {
        super.setMailPanelEnabled(enable);
        this.mailButton.setSelected(enable);
    }
}

