/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.StringStyle;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.enums.FormatLabels;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class FormattedFont {
    private static Integer underline;
    private static Float bold;
    private static Float italic;
    private final String string;
    private final AttributedString atrString;
    private final FontRenderContext fontRenderContext;
    private final TextLayout textLayout;

    public FormattedFont(String stringWithFormatLabels, double fontSize, Font font, FontRenderContext fontRenderContext) {
        this(StringStyle.analyzeFormatLabels((String)stringWithFormatLabels), fontSize, font, fontRenderContext);
    }

    public FormattedFont(StringStyle text, double fontSize, Font font, FontRenderContext fontRenderContext) {
        FormattedFont.setFormat(text);
        this.string = text.getStringWithoutMarkup();
        this.atrString = new AttributedString(this.string);
        this.fontRenderContext = fontRenderContext;
        this.atrString.addAttribute(TextAttribute.FAMILY, font.getFamily());
        this.atrString.addAttribute(TextAttribute.SIZE, fontSize);
        this.atrString.addAttribute(TextAttribute.WEIGHT, bold);
        this.atrString.addAttribute(TextAttribute.POSTURE, italic);
        this.atrString.addAttribute(TextAttribute.UNDERLINE, underline, 0, this.string.length());
        this.textLayout = new TextLayout(this.getAttributedCharacterIterator(), fontRenderContext);
    }

    public String getString() {
        return this.string;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public AttributedCharacterIterator getAttributedCharacterIterator() {
        return this.atrString.getIterator();
    }

    private static void setFormat(StringStyle style) {
        underline = style.getFormat().contains(FormatLabels.UNDERLINE) ? TextAttribute.UNDERLINE_ON : Integer.valueOf(-1);
        bold = style.getFormat().contains(FormatLabels.BOLD) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
        italic = style.getFormat().contains(FormatLabels.ITALIC) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
    }

    public double getWidth() {
        return this.textLayout.getVisibleAdvance();
    }

    public double getHeight() {
        return this.textLayout.getBounds().getHeight();
    }

    public DimensionDouble getDimensions() {
        return new DimensionDouble(this.getWidth(), this.getHeight());
    }
}

