/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.swing.javascriptparser;

import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.JavascriptCodeParser;
import com.baselet.diagram.draw.swing.javascriptparser.CustomFunctionObject;
import com.baselet.diagram.draw.swing.javascriptparser.DrawerScriptable;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptParserSwing
extends JavascriptCodeParser {
    private static final String DRAWMETHODS_PREFIX = "draw";
    private final DrawerScriptable drawerScriptable;

    public JavascriptParserSwing(DrawHandler drawer) {
        this.drawerScriptable = new DrawerScriptable(drawer);
    }

    public void parse(String code, int width, int height) {
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        DrawerScriptable scriptable = this.drawerScriptable;
        scriptable.setParentScope((Scriptable)scope);
        this.drawerScriptable.setScope((Scriptable)scope);
        for (Method method : DrawerScriptable.class.getMethods()) {
            if (!method.getName().startsWith(DRAWMETHODS_PREFIX)) continue;
            CustomFunctionObject scriptableInstanceMethodBoundJavascriptFunction = new CustomFunctionObject(method.getName(), method, (Scriptable)scriptable);
            scope.put(method.getName(), (Scriptable)scope, (Object)scriptableInstanceMethodBoundJavascriptFunction);
        }
        this.setGlobalVariables((Scriptable)scope, width, height);
        cx.evaluateString((Scriptable)scope, code, "JS", 1, null);
    }

    private void setGlobalVariables(Scriptable scope, int width, int height) {
        scope.put("width", scope, (Object)width);
        scope.put("height", scope, (Object)height);
        scope.put("center", scope, (Object)"center");
        scope.put("left", scope, (Object)"left");
        scope.put("right", scope, (Object)"right");
        scope.put("red", scope, (Object)"red");
        scope.put("green", scope, (Object)"green");
        scope.put("blue", scope, (Object)"blue");
        scope.put("bg", scope, (Object)"bg");
        scope.put("fg", scope, (Object)"fg");
        scope.put("lt", scope, (Object)LineType.SOLID.getValue());
        scope.put("lw", scope, (Object)1.0);
    }
}

