/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.io;

import com.baselet.control.config.Config;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.util.Path;
import com.baselet.control.util.RecentlyUsedFilesList;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.Notifier;
import com.baselet.diagram.io.InputHandler;
import com.baselet.diagram.io.OutputHandler;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import com.baselet.gui.CurrentGui;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class DiagramFileHandler {
    private static final Logger log = LoggerFactory.getLogger(DiagramFileHandler.class);
    private String fileName;
    private final DiagramHandler handler;
    private File file;
    private File lastExportFile;
    private final HashMap<String, FileFilter> filters = new HashMap();
    private final HashMap<FileFilter, String> fileextensions = new HashMap();
    private final OwnFileFilter filterxml = new OwnFileFilter(Program.getInstance().getExtension(), Program.getInstance().getProgramName() + " diagram format");
    private final OwnFileFilter filterbmp = new OwnFileFilter("bmp", "BMP");
    private final OwnFileFilter filtereps = new OwnFileFilter("eps", "EPS");
    private final OwnFileFilter filtergif = new OwnFileFilter("gif", "GIF");
    private final OwnFileFilter filterjpg = new OwnFileFilter("jpg", "JPG");
    private final OwnFileFilter filterpdf = new OwnFileFilter("pdf", "PDF");
    private final OwnFileFilter filterpng = new OwnFileFilter("png", "PNG");
    private final OwnFileFilter filtersvg = new OwnFileFilter("svg", "SVG");
    private final OwnFileFilter[] saveFileFilter = new OwnFileFilter[]{this.filterxml};
    private final OwnFileFilter[] exportFileFilter = new OwnFileFilter[]{this.filterbmp, this.filtereps, this.filtergif, this.filterjpg, this.filterpdf, this.filterpng, this.filtersvg};
    private final List<OwnFileFilter> allFileFilters = new ArrayList<OwnFileFilter>();

    protected DiagramFileHandler(DiagramHandler diagramHandler, File file) {
        this.handler = diagramHandler;
        this.fileName = file != null ? file.getName() : "new." + Program.getInstance().getExtension();
        this.file = file;
        this.lastExportFile = file;
        this.allFileFilters.addAll(Arrays.asList(this.saveFileFilter));
        this.allFileFilters.addAll(Arrays.asList(this.exportFileFilter));
        for (OwnFileFilter filter : this.allFileFilters) {
            this.filters.put(filter.getFormat(), filter);
            this.fileextensions.put(filter, filter.getFormat());
        }
    }

    public static DiagramFileHandler createInstance(DiagramHandler diagramHandler, File file) {
        return new DiagramFileHandler(diagramHandler, file);
    }

    private JFileChooser createSaveFileChooser(boolean exportCall, String filePath) {
        File initialDirectory = filePath != null && !filePath.isEmpty() ? new File(this.directory(filePath)) : this.calcInitialDir(exportCall);
        JFileChooser fileChooser = new JFileChooser(initialDirectory);
        fileChooser.setAcceptAllFileFilterUsed(false);
        File selectedFile = filePath != null && !filePath.isEmpty() ? new File(this.filename(filePath)) : new File(CurrentDiagram.getInstance().getDiagramHandler().getName());
        fileChooser.setSelectedFile(selectedFile);
        return fileChooser;
    }

    private File calcInitialDir(boolean exportCall) {
        if (exportCall && this.lastExportFile != null) {
            return this.lastExportFile;
        }
        if (this.file != null) {
            return this.file;
        }
        return new File(Config.getInstance().getSaveFileHome());
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullPathName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return "";
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        CurrentGui.getInstance().getGui().updateDiagramName(this.handler, this.handler.getName());
    }

    private void createXMLOutputDoc(Document doc, Collection<GridElement> elements, Element current) {
        for (GridElement e : elements) {
            this.appendRecursively(doc, current, e);
        }
    }

    private void appendRecursively(Document doc, Element parentXmlElement, GridElement e) {
        parentXmlElement.appendChild(this.createXmlElementForGridElement(doc, e));
    }

    private Element createXmlElementForGridElement(Document doc, GridElement e) {
        Element elType;
        Class<?> c = e.getClass();
        String sElType = c.getName();
        String sElPanelAttributes = e.getPanelAttributes();
        String sElAdditionalAttributes = e.getAdditionalAttributes();
        Element el = doc.createElement("element");
        if (e instanceof NewGridElement) {
            elType = doc.createElement("id");
            elType.appendChild(doc.createTextNode(((NewGridElement)e).getId().toString()));
            el.appendChild(elType);
        } else {
            elType = doc.createElement("type");
            elType.appendChild(doc.createTextNode(sElType));
            el.appendChild(elType);
        }
        Element elCoor = doc.createElement("coordinates");
        el.appendChild(elCoor);
        Element elX = doc.createElement("x");
        elX.appendChild(doc.createTextNode("" + e.getRectangle().x));
        elCoor.appendChild(elX);
        Element elY = doc.createElement("y");
        elY.appendChild(doc.createTextNode("" + e.getRectangle().y));
        elCoor.appendChild(elY);
        Element elW = doc.createElement("w");
        elW.appendChild(doc.createTextNode("" + e.getRectangle().width));
        elCoor.appendChild(elW);
        Element elH = doc.createElement("h");
        elH.appendChild(doc.createTextNode("" + e.getRectangle().height));
        elCoor.appendChild(elH);
        Element elPA = doc.createElement("panel_attributes");
        elPA.appendChild(doc.createTextNode(sElPanelAttributes));
        el.appendChild(elPA);
        Element elAA = doc.createElement("additional_attributes");
        elAA.appendChild(doc.createTextNode(sElAdditionalAttributes));
        el.appendChild(elAA);
        if (e instanceof CustomElement) {
            Element elCO = doc.createElement("custom_code");
            elCO.appendChild(doc.createTextNode(((CustomElement)e).getCode()));
            el.appendChild(elCO);
        }
        return el;
    }

    protected String createStringToBeSaved() {
        DocumentBuilder db = null;
        String returnString = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("diagram");
            root.setAttribute("program", Program.getInstance().getProgramName().toLowerCase());
            root.setAttribute("version", String.valueOf(Program.getInstance().getVersion()));
            doc.appendChild(root);
            String helptext = this.handler.getHelpText();
            if (!helptext.equals(Constants.getDefaultHelptext())) {
                Element help = doc.createElement("help_text");
                help.appendChild(doc.createTextNode(helptext));
                root.appendChild(help);
            }
            Element zoom = doc.createElement("zoom_level");
            zoom.appendChild(doc.createTextNode(String.valueOf(this.handler.getGridSize())));
            root.appendChild(zoom);
            this.createXMLOutputDoc(doc, this.handler.getDrawPanel().getGridElements(), root);
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            returnString = stringWriter.toString();
        }
        catch (Exception e) {
            log.error("Error saving XML.", (Throwable)e);
        }
        return returnString;
    }

    public void doOpen() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            if (Config.getInstance().isSecureXmlProcessing()) {
                spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            SAXParser parser = spf.newSAXParser();
            FileInputStream input = new FileInputStream(this.file);
            InputHandler xmlhandler = new InputHandler(this.handler);
            parser.parse((InputStream)input, (DefaultHandler)xmlhandler);
            input.close();
        }
        catch (Exception e) {
            log.error("Cannot open the file: " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    public String doSaveAs(String filePath, String extension) throws IOException {
        boolean ownXmlFormat = extension.equals(Program.getInstance().getExtension());
        JFileChooser fileChooser = this.createSaveFileChooser(!ownXmlFormat, filePath);
        String chosenFileName = this.chooseFileName(ownXmlFormat, this.filters.get(extension), fileChooser);
        String chosenExtension = this.fileextensions.get(fileChooser.getFileFilter());
        if (chosenFileName == null) {
            return null;
        }
        if (!chosenFileName.endsWith("." + chosenExtension)) {
            chosenFileName = chosenFileName + "." + chosenExtension;
        }
        File fileToSave = new File(chosenFileName);
        Config.getInstance().setSaveFileHome(fileToSave.getParent());
        if (chosenExtension.equals(Program.getInstance().getExtension())) {
            this.file = fileToSave;
            this.setFileName(this.file.getName());
            this.save();
        } else {
            this.lastExportFile = fileToSave;
            this.doExportAs(extension, fileToSave);
        }
        return fileToSave.getAbsolutePath();
    }

    public String doSaveAs(String fileextension) throws IOException {
        return this.doSaveAs(null, fileextension);
    }

    public File doSaveTempDiagram(String filename, String fileextension) throws IOException {
        File tempFile = new File(Path.temp() + filename + "." + fileextension);
        tempFile.deleteOnExit();
        if (fileextension.equals(Program.getInstance().getExtension())) {
            this.save(tempFile, true);
        } else {
            this.doExportAs(fileextension, tempFile);
        }
        return tempFile;
    }

    public void doSave() throws IOException {
        if (this.file == null || !this.file.exists()) {
            this.doSaveAs(Program.getInstance().getExtension());
        } else {
            this.save();
        }
    }

    public void doExportAs(String extension, File file) throws IOException {
        try {
            OutputHandler.createAndOutputToFile(extension, file, this.handler);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void save() throws UnsupportedEncodingException, FileNotFoundException {
        this.save(this.file, false);
    }

    private void save(File saveToFile, boolean tempFile) throws UnsupportedEncodingException, FileNotFoundException {
        String tmp = this.createStringToBeSaved();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(saveToFile), "UTF-8"));
        out.print(tmp);
        out.close();
        if (!tempFile) {
            this.handler.setChanged(false);
            RecentlyUsedFilesList.getInstance().add(saveToFile.getAbsolutePath());
        }
        Notifier.getInstance().showInfo(saveToFile.getAbsolutePath() + " saved");
    }

    private String chooseFileName(boolean ownXmlFormat, FileFilter filefilter, JFileChooser fileChooser) {
        String fileName = null;
        this.setAvailableFileFilters(ownXmlFormat, fileChooser);
        fileChooser.setFileFilter(filefilter);
        int returnVal = fileChooser.showSaveDialog(CurrentGui.getInstance().getGui().getMainFrame());
        if (returnVal == 0) {
            int overwriteQuestionResult;
            File selectedFileWithExt = this.getFileWithExtension(fileChooser);
            if (selectedFileWithExt.exists() && (overwriteQuestionResult = JOptionPane.showConfirmDialog(CurrentGui.getInstance().getGui().getMainFrame(), "File already exists! Overwrite?", "Overwrite File", 0)) == 1) {
                return this.chooseFileName(ownXmlFormat, filefilter, fileChooser);
            }
            fileName = selectedFileWithExt.getAbsolutePath();
        }
        return fileName;
    }

    private String directory(String filePath) {
        File fileObject = new File(filePath);
        File fileObjectAbsolute = new File(fileObject.getAbsolutePath());
        return fileObjectAbsolute.getParent();
    }

    private String filename(String filePath) {
        File fileObject = new File(filePath);
        String filename = fileObject.getName();
        int extensionPos = filename.lastIndexOf(".");
        if (extensionPos > 0) {
            String filenameWithoutExtension = filename.substring(0, extensionPos);
            return filenameWithoutExtension;
        }
        return filename;
    }

    private File getFileWithExtension(JFileChooser fileChooser) {
        String extension = "." + this.fileextensions.get(fileChooser.getFileFilter());
        String filename = fileChooser.getSelectedFile().getAbsolutePath();
        if (!filename.endsWith(extension)) {
            filename = filename + extension;
        }
        File selectedFileWithExt = new File(filename);
        return selectedFileWithExt;
    }

    private void setAvailableFileFilters(boolean ownXmlFormat, JFileChooser fileChooser) {
        if (ownXmlFormat) {
            fileChooser.resetChoosableFileFilters();
            fileChooser.addChoosableFileFilter(this.filterxml);
        } else {
            fileChooser.resetChoosableFileFilters();
            fileChooser.addChoosableFileFilter(this.filterbmp);
            fileChooser.addChoosableFileFilter(this.filtereps);
            fileChooser.addChoosableFileFilter(this.filtergif);
            fileChooser.addChoosableFileFilter(this.filterjpg);
            fileChooser.addChoosableFileFilter(this.filterpdf);
            fileChooser.addChoosableFileFilter(this.filterpng);
            fileChooser.addChoosableFileFilter(this.filtersvg);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramFileHandler other = (DiagramFileHandler)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    protected static class OwnFileFilter
    extends FileFilter {
        private final String format;
        private final String description;

        protected OwnFileFilter(String format, String description) {
            this.format = format;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith("." + this.format) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.description + " (*." + this.format + ")";
        }

        public String getFormat() {
            return this.format;
        }
    }
}

