/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.io;

import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.Config;
import com.baselet.control.enums.Program;
import com.baselet.control.util.Utils;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.FontHandler;
import com.baselet.diagram.io.PdfFontMapper;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.interfaces.Component;
import com.baselet.element.interfaces.GridElement;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JLayeredPane;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;

public class OutputHandler {
    private OutputHandler() {
    }

    public static void createAndOutputToFile(String extension, File file, DiagramHandler handler) throws Exception {
        FileOutputStream ostream = new FileOutputStream(file);
        OutputHandler.createToStream(extension, ostream, handler);
        ((OutputStream)ostream).close();
    }

    public static void createToStream(String extension, OutputStream ostream, DiagramHandler handler) throws Exception {
        int oldZoom = handler.getGridSize();
        handler.setGridAndZoom(10, false);
        List<GridElement> elementsToDraw = handler.getDrawPanel().getSelector().getSelectedElements();
        if (elementsToDraw.isEmpty()) {
            elementsToDraw = handler.getDrawPanel().getGridElements();
        }
        OutputHandler.exportToOutputStream(extension, ostream, elementsToDraw, handler.getFontHandler());
        handler.setGridAndZoom(oldZoom, false);
    }

    private static void exportToOutputStream(String extension, OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont) throws IOException {
        for (GridElement ge : entities) {
            ge.getDeprecatedAddons().doBeforeExport();
        }
        if (extension.equals("eps")) {
            OutputHandler.exportEps(ostream, entities, diagramFont);
        } else if (extension.equals("pdf")) {
            OutputHandler.exportPdf(ostream, entities, diagramFont);
        } else if (extension.equals("svg")) {
            OutputHandler.exportSvg(ostream, entities, diagramFont);
        } else if (OutputHandler.isImageExtension(extension)) {
            OutputHandler.exportImg(extension, ostream, entities, diagramFont);
        } else {
            throw new IllegalArgumentException(extension + " is an invalid format");
        }
    }

    private static void exportEps(OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont) throws IOException {
        Rectangle bounds = DrawPanel.getContentBounds(Config.getInstance().getPrintPadding(), entities);
        EpsGraphics2D graphics2d = new EpsGraphics2D(Program.getInstance().getProgramName() + " Diagram", ostream, 0, 0, bounds.width, bounds.height);
        OutputHandler.setGraphicsBorders(bounds, (Graphics2D)graphics2d, 1);
        OutputHandler.paintEntitiesIntoGraphics2D((Graphics2D)graphics2d, entities, diagramFont);
        graphics2d.flush();
        graphics2d.close();
    }

    private static void exportPdf(OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont) throws IOException {
        try {
            PdfFontMapper mapper = new PdfFontMapper();
            Rectangle bounds = DrawPanel.getContentBounds(Config.getInstance().getPrintPadding(), entities);
            Document document = new Document(new com.itextpdf.text.Rectangle((float)bounds.getWidth(), (float)bounds.getHeight()));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)ostream);
            document.open();
            PdfGraphics2D graphics2d = new PdfGraphics2D(writer.getDirectContent(), (float)bounds.getWidth(), (float)bounds.getHeight(), (FontMapper)mapper);
            Dimension trans = new Dimension(bounds.getX(), bounds.getY());
            graphics2d.translate(-trans.getWidth(), -trans.getHeight());
            OutputHandler.paintEntitiesIntoGraphics2D((Graphics2D)graphics2d, entities, diagramFont);
            graphics2d.dispose();
            document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static void exportSvg(OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont) throws IOException {
        Rectangle bounds = DrawPanel.getContentBounds(Config.getInstance().getPrintPadding(), entities);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D graphics2d = new SVGGraphics2D(document);
        graphics2d.setSVGCanvasSize(Converter.convert(bounds.getSize()));
        OutputHandler.paintEntitiesIntoGraphics2D((Graphics2D)graphics2d, entities, diagramFont);
        Element root = graphics2d.getRoot();
        root.setAttributeNS(null, "viewBox", String.format("%d %d %d %d", bounds.x, bounds.y, bounds.width, bounds.height));
        OutputStreamWriter out = new OutputStreamWriter(ostream, "UTF-8");
        graphics2d.stream(root, (Writer)out, false, false);
        graphics2d.dispose();
    }

    private static void exportImg(String imgType, OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont) throws IOException {
        Integer scale = Config.getInstance().getExportScale();
        boolean exportedWithDpi = OutputHandler.exportImgAndSetDpi(imgType, ostream, entities, diagramFont, scale);
        if (!exportedWithDpi) {
            ImageIO.write((RenderedImage)OutputHandler.createImageForGridElements(entities, diagramFont, scale), imgType, ostream);
        }
        ostream.flush();
        ostream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exportImgAndSetDpi(String imgType, OutputStream ostream, Collection<GridElement> entities, FontHandler diagramFont, Integer scale) throws IIOInvalidTreeException, IOException {
        Integer dpi = Config.getInstance().getExportDpi();
        if (dpi != null) {
            Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(imgType);
            while (iw.hasNext()) {
                ImageWriter writer = iw.next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
                IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                OutputHandler.setImgDPI(dpi, metadata);
                ImageOutputStream stream = ImageIO.createImageOutputStream(ostream);
                try {
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(OutputHandler.createImageForGridElements(entities, diagramFont, scale), null, metadata), writeParam);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    stream.close();
                }
            }
        }
        return false;
    }

    private static void setImgDPI(Integer dpi, IIOMetadata metadata) throws IIOInvalidTreeException {
        double INCH_2_CM = 2.54;
        double dotsPerMilli = 1.0 * (double)dpi.intValue() / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public static BufferedImage createImageForGridElements(Collection<GridElement> entities, FontHandler diagramFont, int scale) {
        Rectangle bounds = DrawPanel.getContentBounds(Config.getInstance().getPrintPadding(), entities);
        BufferedImage im = new BufferedImage(bounds.width == 0 ? 1 : bounds.width * scale, bounds.height == 0 ? 1 : bounds.height * scale, 1);
        Graphics2D graphics2d = im.createGraphics();
        graphics2d.setRenderingHints(Utils.getUxRenderingQualityHigh(true));
        OutputHandler.setGraphicsBorders(bounds, graphics2d, scale);
        graphics2d.scale(scale, scale);
        OutputHandler.paintEntitiesIntoGraphics2D(graphics2d, entities, diagramFont);
        graphics2d.dispose();
        return im;
    }

    private static void setGraphicsBorders(Rectangle bounds, Graphics2D graphics2d, int scale) {
        graphics2d.translate(-bounds.x * scale, -bounds.y * scale);
        graphics2d.clipRect(bounds.x * scale, bounds.y * scale, bounds.width * scale, bounds.height * scale);
        graphics2d.setColor(Color.white);
        graphics2d.fillRect(bounds.x * scale, bounds.y * scale, bounds.width * scale, bounds.height * scale);
    }

    private static boolean isImageExtension(String ext) {
        return ImageIO.getImageWritersBySuffix(ext).hasNext();
    }

    public static void paintEntitiesIntoGraphics2D(Graphics2D g2d, Collection<GridElement> entities, FontHandler diagramFont) {
        DiagramHandler handler = DiagramHandler.forExport(diagramFont);
        JLayeredPane tempPanel = new JLayeredPane();
        for (GridElement entity : entities) {
            GridElement clone = ElementFactorySwing.createCopy(entity, handler);
            Component component = clone.getComponent();
            component.translateForExport();
            tempPanel.add((java.awt.Component)component, clone.getLayer());
        }
        tempPanel.validate();
        tempPanel.setBackground(Color.WHITE);
        tempPanel.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        tempPanel.update(g2d);
    }
}

