/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.custom;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.custom.CompileError;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.diagram.draw.swing.DrawHandlerSwing;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import java.util.List;

public class CustomElementWithErrors
extends CustomElement {
    private static final long serialVersionUID = 1L;
    private List<CompileError> errors;

    public CustomElementWithErrors() {
    }

    public CustomElementWithErrors(List<CompileError> errors) {
        this.errors = errors;
    }

    @Override
    public void paint() {
        DrawHandlerSwing drawer = new DrawHandlerSwing(this);
        drawer.setGraphics(this.g2);
        drawer.setHandler(HandlerElementMap.getHandlerForElement(this));
        drawer.setForegroundColor(ThemeFactory.getCurrentTheme().getColor(Theme.PredefinedColors.RED));
        drawer.drawRectangle(0.0, 0.0, this.getRealSize().width, this.getRealSize().height);
        if (this.errors != null) {
            double y = this.textHeight();
            double x = HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts(false);
            drawer.print("Custom Element With Errors:", x, (int)y, AlignHorizontal.LEFT);
            y += (double)this.textHeight();
            for (CompileError error : this.errors) {
                drawer.print(error.getLineNr() + ": " + error.getError(), x, (int)y, AlignHorizontal.LEFT);
                y += (double)this.textHeight();
            }
        }
        drawer.drawAll(HandlerElementMap.getHandlerForElement(this).getDrawPanel().getSelector().isSelected(this));
    }

    @Override
    public final GridElement cloneFromMe() {
        CustomElementWithErrors e = (CustomElementWithErrors)super.cloneFromMe();
        e.setCode(this.getCode());
        e.errors = this.errors;
        return e;
    }
}

