/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLauncher {
    private static final Logger log = LoggerFactory.getLogger(BrowserLauncher.class);

    public static void openURL(String url) {
        block11: {
            try {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.browse(new URI(url));
                        return;
                    }
                    catch (Exception desktop) {
                        // empty catch block
                    }
                }
                if (SystemInfo.OS == Os.MAC) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                    break block11;
                }
                if (SystemInfo.OS == Os.WINDOWS) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break block11;
                }
                try {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                    return;
                }
                catch (IOException fileMgr) {
                    String[] browsers = new String[]{"firefox", "chromium", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String browser = null;
                    for (int count = 0; count < browsers.length && browser == null; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                        browser = browsers[count];
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
            catch (Exception e) {
                log.error("Error at opening the URL.", (Throwable)e);
            }
        }
    }

    public static String readURL(String url) throws IOException {
        StringBuilder sb = new StringBuilder("");
        Scanner sc = null;
        try {
            sc = new Scanner(new URL(url).openStream());
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append("\n");
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return sb.toString();
    }
}

