/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.Main;
import com.baselet.control.config.Config;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.diagram.DiagramHandler;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.HintTextField;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanel
extends JPanel
implements ActionListener {
    private final Logger log = LoggerFactory.getLogger(OptionPanel.class);
    private static OptionPanel optionpanel;
    private final JFrame optionframe;
    private final JCheckBox show_stickingpolygon = new JCheckBox();
    private final JCheckBox show_grid = new JCheckBox();
    private final JCheckBox enable_custom_elements = new JCheckBox();
    private final JCheckBox checkForUpdates = new JCheckBox();
    private final JCheckBox developerMode = new JCheckBox();
    private final JTextField pdfFont = new HintTextField("Path to font e.g.; c:/windows/fonts/msgothic.ttc,1");
    private final JTextField pdfFontBold = new HintTextField("same as above but used for bold text");
    private final JTextField pdfFontItalic = new HintTextField("same as above but used for italic text");
    private final JTextField pdfFontBoldItalic = new HintTextField("same as above but used for bold+italic text");
    private final JComboBox ui_manager;
    private final JComboBox default_fontsize = new JComboBox<Integer>(new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
    private final JComboBox propertiesPanelFontsize = new JComboBox<Integer>(new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
    private final JComboBox exportScale = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
    private final JComboBox default_fontfamily = new JComboBox<String>(Constants.fontFamilyList.toArray(new String[Constants.fontFamilyList.size()]));
    private final Vector<String> uis_technicalNames = new Vector();

    public static OptionPanel getInstance() {
        if (optionpanel == null) {
            optionpanel = new OptionPanel();
        }
        return optionpanel;
    }

    private OptionPanel() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        this.setLayout(new GridLayout(0, 2, 4, 4));
        this.setAlignmentX(0.0f);
        Vector<String> uis_humanReadableNameVector = new Vector<String>();
        for (UIManager.LookAndFeelInfo info : lookAndFeelInfoArray = Constants.lookAndFeels.toArray(new UIManager.LookAndFeelInfo[Constants.lookAndFeels.size()])) {
            this.uis_technicalNames.add(info.getClassName());
            uis_humanReadableNameVector.add(info.getName());
        }
        this.ui_manager = new JComboBox(uis_humanReadableNameVector);
        this.add(new JLabel("Show sticking polygon"));
        this.add(this.show_stickingpolygon);
        this.add(new JLabel("Show grid"));
        this.add(this.show_grid);
        this.add(new JLabel("Enable Custom Elements"));
        this.add(this.enable_custom_elements);
        this.add(new JLabel("Check for " + Program.getInstance().getProgramName() + " updates"));
        this.add(this.checkForUpdates);
        if (Program.getInstance().getRuntimeType() == RuntimeType.STANDALONE) {
            this.add(new JLabel(Program.getInstance().getProgramName() + " style"));
            this.add(this.ui_manager);
        }
        this.add(new JLabel("Default fontsize"));
        this.add(this.default_fontsize);
        this.add(new JLabel("Properties panel fontsize (requires restart)"));
        this.add(this.propertiesPanelFontsize);
        this.add(new JLabel("Export Scale for image export"));
        this.add(this.exportScale);
        this.add(new JLabel("Default fontfamily"));
        this.add(this.default_fontfamily);
        this.add(new JLabel("Developer Mode (show extended Element Info)"));
        this.add(this.developerMode);
        this.add(new JLabel("Optional font to embedd in PDF - normal text"));
        this.add(this.pdfFont);
        this.add(new JLabel("Optional font to embedd in PDF - bold text"));
        this.add(this.pdfFontBold);
        this.add(new JLabel("Optional font to embedd in PDF - italic text"));
        this.add(this.pdfFontItalic);
        this.add(new JLabel("Optional font to embedd in PDF - bold+italic"));
        this.add(this.pdfFontBoldItalic);
        JButton button_ok = new JButton("Ok");
        button_ok.setActionCommand("Ok");
        button_ok.addActionListener(this);
        JButton button_cancel = new JButton("Cancel");
        button_cancel.setActionCommand("Cancel");
        button_cancel.addActionListener(this);
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.add(Box.createHorizontalGlue());
        button_panel.add(button_cancel);
        button_panel.add(Box.createRigidArea(new Dimension(20, 0)));
        button_panel.add(button_ok);
        button_panel.add(Box.createHorizontalGlue());
        button_panel.setAlignmentX(0.0f);
        JPanel parent = new JPanel();
        parent.setLayout(new BoxLayout(parent, 1));
        parent.add(Box.createRigidArea(new Dimension(10, 10)));
        parent.add(this);
        parent.add(Box.createRigidArea(new Dimension(0, 20)));
        parent.add(button_panel);
        parent.add(Box.createRigidArea(new Dimension(0, 20)));
        this.optionframe = new JFrame(Program.getInstance().getProgramName() + " Options");
        this.optionframe.setContentPane(parent);
        this.optionframe.pack();
    }

    public void showOptionPanel() {
        this.show_stickingpolygon.setSelected(SharedConfig.getInstance().isShow_stickingpolygon());
        this.show_grid.setSelected(Config.getInstance().isShow_grid());
        this.enable_custom_elements.setSelected(Config.getInstance().isEnable_custom_elements());
        this.checkForUpdates.setSelected(Config.getInstance().isCheckForUpdates());
        this.developerMode.setSelected(SharedConfig.getInstance().isDev_mode());
        this.ui_manager.setSelectedIndex(this.uis_technicalNames.indexOf(Config.getInstance().getUiManager()));
        this.default_fontsize.setSelectedItem(Config.getInstance().getDefaultFontsize());
        this.propertiesPanelFontsize.setSelectedItem(Config.getInstance().getPropertiesPanelFontsize());
        this.exportScale.setSelectedItem(Config.getInstance().getExportScale());
        this.default_fontfamily.setSelectedItem(Config.getInstance().getDefaultFontFamily());
        this.pdfFont.setText(Config.getInstance().getPdfExportFont());
        this.pdfFontBold.setText(Config.getInstance().getPdfExportFontBold());
        this.pdfFontItalic.setText(Config.getInstance().getPdfExportFontItalic());
        this.pdfFontBoldItalic.setText(Config.getInstance().getPdfExportFontBoldItalic());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPanel.this.optionframe.setLocationRelativeTo(CurrentGui.getInstance().getGui().getMainFrame());
                OptionPanel.this.optionframe.setVisible(true);
                OptionPanel.this.optionframe.toFront();
            }
        });
    }

    private void hideOptionPanel() {
        this.optionframe.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.hideOptionPanel();
        if (ae.getActionCommand().equals("Ok")) {
            SharedConfig.getInstance().setShow_stickingpolygon(this.show_stickingpolygon.isSelected());
            Config.getInstance().setShow_grid(this.show_grid.isSelected());
            Config.getInstance().setEnable_custom_elements(this.enable_custom_elements.isSelected());
            Config.getInstance().setCheckForUpdates(this.checkForUpdates.isSelected());
            SharedConfig.getInstance().setDev_mode(this.developerMode.isSelected());
            Config.getInstance().setDefaultFontsize((Integer)this.default_fontsize.getSelectedItem());
            Config.getInstance().setPdfExportFont(this.pdfFont.getText());
            Config.getInstance().setPdfExportFontBold(this.pdfFontBold.getText());
            Config.getInstance().setPdfExportFontItalic(this.pdfFontItalic.getText());
            Config.getInstance().setPdfExportFontBoldItalic(this.pdfFontBoldItalic.getText());
            String newui = this.uis_technicalNames.get(this.ui_manager.getSelectedIndex());
            if (newui != null && !newui.equals(Config.getInstance().getUiManager())) {
                Config.getInstance().setUiManager(newui);
                CurrentGui.getInstance().getGui().setLookAndFeel(newui, this.optionframe);
            }
            for (DiagramHandler d : Main.getInstance().getDiagramsAndPalettes()) {
                d.getFontHandler().resetFontSize();
                d.getDrawPanel().updateElements();
                d.getDrawPanel().repaint();
            }
            Config.getInstance().setPropertiesPanelFontsize((Integer)this.propertiesPanelFontsize.getSelectedItem());
            Config.getInstance().setExportScale((Integer)this.exportScale.getSelectedItem());
            String newfamily = (String)this.default_fontfamily.getSelectedItem();
            Config.getInstance().setDefaultFontFamily(newfamily);
        }
    }
}

