/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.menu;

import com.baselet.control.Main;
import com.baselet.control.constants.Constants;
import com.baselet.control.constants.MenuConstants;
import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import com.baselet.control.util.RecentlyUsedFilesList;
import com.baselet.diagram.draw.helper.theme.Theme;
import com.baselet.diagram.draw.helper.theme.ThemeFactory;
import com.baselet.gui.helper.PlainColorIcon;
import com.baselet.gui.menu.MenuFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MenuFactorySwing
extends MenuFactory {
    private static MenuFactorySwing instance = null;

    public static MenuFactorySwing getInstance() {
        if (instance == null) {
            instance = new MenuFactorySwing();
        }
        return instance;
    }

    public JMenuItem createNew() {
        return this.createJMenuItem(false, "New", 78, true, null);
    }

    public JMenuItem createOpen() {
        return this.createJMenuItem(false, "Open...", 79, true, null);
    }

    public JMenuItem createClose() {
        return this.createJMenuItem(false, "Close", "Close", 67, 87, true, null);
    }

    public JMenu createRecentFiles() {
        final JMenu recentFiles = new JMenu();
        recentFiles.setText("Recent files");
        recentFiles.setMnemonic(82);
        recentFiles.addMenuListener(new MenuListener(){

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                recentFiles.removeAll();
                Iterator<Integer> mnemonicsIter = Arrays.asList(49, 50, 51, 52, 53, 54, 55, 56, 57, 48).iterator();
                Iterator<Integer> prefixIter = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).iterator();
                for (String file : RecentlyUsedFilesList.getInstance()) {
                    Integer mnemonic = mnemonicsIter.hasNext() ? mnemonicsIter.next() : null;
                    String prefix = prefixIter.hasNext() ? prefixIter.next().toString() : "";
                    recentFiles.add(MenuFactorySwing.this.createJMenuItem(false, prefix + " " + file, "Recent files", mnemonic, null, file));
                }
            }
        });
        return recentFiles;
    }

    public JMenuItem createGenerate() {
        return this.createJMenuItemNoShortcut(false, "Generate Class Elements from Files or Directory...", 71);
    }

    public JMenuItem createGenerateOptions() {
        return this.createJMenuItemNoShortcut(false, "Generate Class Element Options...", 73);
    }

    public JMenuItem createSave() {
        return this.createJMenuItem(true, "Save", 83, true, null);
    }

    public JMenuItem createSaveAs() {
        return this.createJMenuItemNoShortcut(true, "Save as...", 86);
    }

    public JMenuItem createExport() {
        return this.createJMenuItem(true, "Export...", 69, true, null);
    }

    public JMenu createExportAs() {
        JMenu export = new JMenu();
        export.setText("Export as...");
        export.setMnemonic(65);
        this.diagramDependendComponents.add(export);
        for (String format : Constants.exportFormatList) {
            export.add(this.createJMenuItem(true, format.toUpperCase(Locale.ENGLISH) + "...", "Export as...", this.exportMnemonic(format), null, format));
        }
        return export;
    }

    private Integer exportMnemonic(String format) {
        if ("bmp".equals(format)) {
            return 66;
        }
        if ("eps".equals(format)) {
            return 69;
        }
        if ("gif".equals(format)) {
            return 71;
        }
        if ("jpg".equals(format)) {
            return 74;
        }
        if ("pdf".equals(format)) {
            return 80;
        }
        if ("png".equals(format)) {
            return 78;
        }
        if ("svg".equals(format)) {
            return 83;
        }
        return null;
    }

    public JMenuItem createMailTo() {
        return this.createJMenuItem(true, "Mail to...", 77, true, null);
    }

    public JMenuItem createEditCurrentPalette() {
        return this.createJMenuItemNoShortcut(false, "Edit Current Palette", 68);
    }

    public JMenuItem createOptions() {
        return this.createJMenuItemNoShortcut(false, "Options...", 84);
    }

    public JMenuItem createPrint() {
        return this.createJMenuItem(true, "Print...", 80, true, null);
    }

    public JMenuItem createExit() {
        return this.createJMenuItemNoShortcut(false, "Exit", 88);
    }

    public JMenuItem createUndo() {
        return this.createJMenuItem(false, "Undo", "Undo", 85, 90, true, null);
    }

    public JMenuItem createRedo() {
        return this.createJMenuItem(false, "Redo", "Redo", 82, 89, true, null);
    }

    public JMenuItem createDelete() {
        int[] keys = new int[]{8, 127};
        if (SystemInfo.OS == Os.MAC) {
            return this.createJMenuItem(false, "Delete", keys, 68, 8);
        }
        return this.createJMenuItem(false, "Delete", keys, 68, 127);
    }

    public JMenuItem createSelectAll() {
        return this.createJMenuItem(false, "Select All", 65, true, null);
    }

    public JMenuItem createGroup() {
        return this.createJMenuItem(false, "Group", 71, true, null);
    }

    public JMenuItem createUngroup() {
        return this.createJMenuItem(false, "Ungroup", "Ungroup", 78, 85, true, null);
    }

    public JMenuItem createCut() {
        return this.createJMenuItem(false, "Cut", "Cut", 84, 88, true, null);
    }

    public JMenuItem createCopy() {
        return this.createJMenuItem(false, "Copy", 67, true, null);
    }

    public JMenuItem createPaste(boolean usedRightClickContextMenu) {
        return this.createJMenuItem(false, "Paste", "Paste", 80, 86, true, usedRightClickContextMenu);
    }

    public JMenuItem createNewCustomElement() {
        return this.createJMenuItemNoShortcut(false, "New...", 78);
    }

    public JMenu createNewCustomElementFromTemplate() {
        JMenu menu = new JMenu("New from Template");
        menu.setMnemonic(69);
        Iterator<Integer> mnemonicsIter = Arrays.asList(49, 50, 51, 52, 53, 54, 55, 56, 57, 48).iterator();
        Iterator<Integer> prefixIter = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).iterator();
        for (String template : Main.getInstance().getTemplateNames()) {
            Integer mnemonic = mnemonicsIter.hasNext() ? mnemonicsIter.next() : null;
            String prefix = prefixIter.hasNext() ? prefixIter.next().toString() : "";
            menu.add(this.createJMenuItem(false, prefix + " " + template, "New from Template", mnemonic, null, null, template));
        }
        return menu;
    }

    public JMenuItem createEditSelected() {
        return this.createJMenuItemNoShortcut(false, "Edit Selected...", 68);
    }

    public JMenuItem createCustomElementTutorial() {
        return this.createJMenuItemNoShortcut(false, "Custom Elements Tutorial...", 84);
    }

    public JMenuItem createOnlineHelp() {
        return this.createJMenuItemNoShortcut(false, "Online Help...", 72);
    }

    public JMenuItem createOnlineSampleDiagrams() {
        return this.createJMenuItemNoShortcut(false, "Online Sample Diagrams...", 83);
    }

    public JMenuItem createVideoTutorials() {
        return this.createJMenuItemNoShortcut(false, "Video Tutorial: Basic Use and Custom Elements...", 84);
    }

    public JMenuItem createProgramHomepage() {
        return this.createJMenuItemNoShortcut(false, MenuConstants.PROGRAM_HOMEPAGE, 85);
    }

    public JMenuItem createRateProgram() {
        return this.createJMenuItemNoShortcut(false, MenuConstants.RATE_PROGRAM, 82);
    }

    public JMenu createSetColor(boolean fg) {
        String name = fg ? "Set foreground color" : "Set background color";
        JMenu menu = new JMenu(name);
        menu.add(this.createJMenuItem(false, "default", name, null));
        for (Theme.PredefinedColors color : ThemeFactory.getCurrentTheme().getColorMap().keySet()) {
            JMenuItem item = this.createJMenuItem(false, color.name(), name, color.name());
            menu.add(item);
            item.setIcon(new PlainColorIcon(color.name()));
        }
        return menu;
    }

    public JMenuItem createAboutProgram() {
        return this.createJMenuItemNoShortcut(false, MenuConstants.ABOUT_PROGRAM, 65);
    }

    public JMenu createAlign() {
        JMenu alignMenu = new JMenu("Align");
        for (String direction : new String[]{"Left", "Right", "Top", "Bottom"}) {
            alignMenu.add(this.createJMenuItem(false, direction, "Align", direction));
        }
        return alignMenu;
    }

    public JMenu createLayerUp() {
        JMenu alignMenu = new JMenu("Layer");
        for (String direction : new String[]{"to back (layer -1)", "to front (layer +1)"}) {
            alignMenu.add(this.createJMenuItem(false, direction, "Layer", direction));
        }
        return alignMenu;
    }

    private JMenuItem createJMenuItemNoShortcut(boolean grayWithoutDiagram, String name, Integer mnemonic) {
        return this.createJMenuItem(grayWithoutDiagram, name, mnemonic, null, null);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String name, Integer mnemonic, Boolean meta, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, name, name, mnemonic, meta, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String menuName, String actionName, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, menuName, actionName, null, null, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String menuName, String actionName, Integer mnemonic, Boolean meta, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, menuName, actionName, mnemonic, mnemonic, meta, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String menuName, final String actionName, Integer mnemonic, Integer shortcut, Boolean meta, final Object param) {
        JMenuItem menuItem = new JMenuItem(menuName);
        if (mnemonic != null) {
            menuItem.setMnemonic(mnemonic);
            if (meta != null && shortcut != null) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(shortcut, meta == false ? 0 : SystemInfo.META_KEY.getMask()));
            }
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuFactorySwing.this.doAction(actionName, param);
            }
        });
        if (grayWithoutDiagram) {
            this.diagramDependendComponents.add(menuItem);
        }
        return menuItem;
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String name, int[] keyEvents, int mnemonic, int shortcut) {
        JMenuItem menuItem = new JMenuItem(name);
        MultipleKeyBindingsAction action = new MultipleKeyBindingsAction(name, shortcut);
        for (int keyEvent : keyEvents) {
            this.addKeyBinding(menuItem, keyEvent, name);
        }
        menuItem.getActionMap().put(name, action);
        menuItem.setAction(action);
        menuItem.setMnemonic(mnemonic);
        if (grayWithoutDiagram) {
            this.diagramDependendComponents.add(menuItem);
        }
        return menuItem;
    }

    private void addKeyBinding(JMenuItem menuItem, int keyEvent, String actionName) {
        menuItem.getInputMap(2).put(KeyStroke.getKeyStroke(keyEvent, 0), actionName);
    }

    private class MultipleKeyBindingsAction
    extends AbstractAction {
        public MultipleKeyBindingsAction(String menuName, int shortcut) {
            super(menuName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(shortcut, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFactorySwing.this.doAction(this.getValue("Name").toString(), null);
        }
    }
}

