/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;
import org.apache.commons.mail.settings.EmailConfiguration;
import org.junit.Before;
import org.junit.Test;

public class EmailLiveTest
extends AbstractEmailTest {
    @Before
    public void setUpLiveTest() {
        System.setProperty("mail.mime.charset", "utf-8");
        System.setProperty("mail.mime.encodefilename", "true");
    }

    protected Email send(Email email) throws EmailException {
        email.buildMimeMessage();
        return email;
    }

    protected String getFromUrl(URL url) throws Exception {
        URLDataSource dataSource = new URLDataSource(url);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)dataSource.getInputStream(), (OutputStream)baos);
        return new String(baos.toByteArray(), "UTF-8");
    }

    private Email create(Class<? extends Email> clazz) throws Exception {
        Email email = clazz.newInstance();
        email.setStartTLSEnabled(true);
        email.setStartTLSRequired(true);
        email.setSSLOnConnect(false);
        email.setSSLCheckServerIdentity(false);
        email.setHostName("localhost");
        email.setSmtpPort(25);
        email.setBounceAddress("test_from@apache.org");
        email.setDebug(false);
        email.setCharset("utf-8");
        email.setFrom("test_from@apache.org");
        email.addTo("test_to@apache.org");
        if ("user" != null) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator("user", "password"));
        }
        return email;
    }

    @Test
    public void testSimpleEmail() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.setSubject("TestSimpleMail");
        email.setMsg("This is a test mail ... :-)");
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/simplemail.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }

    @Test
    public void testFoldedHeaderValue() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.setSubject("TestFoldedHeaderMail");
        email.setMsg("This is a test mail with a folded header value... :-)");
        email.addHeader("X-TestHeader", "This is a very long header value which should be folded into two lines, hopefully");
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/foldedheader.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }

    @Test
    public void testMultiPartEmail() throws Exception {
        MultiPartEmail email = (MultiPartEmail)this.create(MultiPartEmail.class);
        email.setSubject("TestMultiPartMail");
        email.setMsg("This is a test mail ... :-)");
        email.attach(new File("./src/test/resources/attachments/logo.pdf"));
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/multipart.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }

    @Test
    public void testHtmlMailMimeLayout() throws Exception {
        URL url = new URL(EmailConfiguration.TEST_URL);
        File imageFile = new File("./src/test/resources/images/asf_logo_wide.gif");
        EmailAttachment attachment = new EmailAttachment();
        File attachmentFile = new File("./src/test/resources/attachments/logo.pdf");
        attachment.setName("logo.pdf");
        attachment.setDescription("The official Apache logo");
        attachment.setPath(attachmentFile.getAbsolutePath());
        HtmlEmail htmlEmail1 = (HtmlEmail)this.create(HtmlEmail.class);
        String textMsg = "Your email client does not support HTML messages";
        String htmlMsg = "<html><b>This is a HTML message without any image</b><html>";
        htmlEmail1.setSubject("[email] 1.Test: text + html content");
        htmlEmail1.setTextMsg(textMsg);
        htmlEmail1.setHtmlMsg(htmlMsg);
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/htmlemail1.eml"), (MimeMessage)this.send((Email)htmlEmail1).getMimeMessage());
        HtmlEmail htmlEmail2 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        htmlMsg = "<html><b>This is a HTML message with an image attachment</b><html>";
        htmlEmail2.setSubject("[email] 2.Test: text + html content + image as attachment");
        htmlEmail2.setTextMsg(textMsg);
        htmlEmail2.setHtmlMsg(htmlMsg);
        htmlEmail2.attach(url, "Apache Logo", "The official Apache logo");
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/htmlemail2.eml"), (MimeMessage)this.send((Email)htmlEmail2).getMimeMessage());
        HtmlEmail htmlEmail3 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        String cid = htmlEmail3.embed(imageFile, "Apache Logo");
        htmlMsg = "<html><b>This is a HTML message with an inline image - <img src=\"cid:" + cid + "\"> and NO attachment</b><html>";
        htmlEmail3.setSubject("[email] 3.Test: text + html content + inline image");
        htmlEmail3.setTextMsg(textMsg);
        htmlEmail3.setHtmlMsg(htmlMsg);
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/htmlemail3.eml"), (MimeMessage)this.send((Email)htmlEmail3).getMimeMessage());
        HtmlEmail htmlEmail4 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        cid = htmlEmail4.embed(imageFile, "Apache Logo");
        htmlMsg = "<html><b>This is a HTML message with an inline image - <img src=\"cid:" + cid + "\"> and attachment</b><html>";
        htmlEmail4.setSubject("[email] 4.Test: text + html content + inline image + attachment");
        htmlEmail4.setTextMsg(textMsg);
        htmlEmail4.setHtmlMsg(htmlMsg);
        htmlEmail4.attach(attachment);
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/htmlemail4.eml"), (MimeMessage)this.send((Email)htmlEmail4).getMimeMessage());
    }

    @Test
    public void testCorrectCharacterEncoding() throws Exception {
        String subject = "[email] 5.Test: Subject with three greek UTF-8 characters : \u03b1\u03b2\u03b3";
        String textMsg = "My test body with with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n";
        String attachmentName = "\u03b1\u03b2\u03b3.txt";
        MultiPartEmail email = (MultiPartEmail)this.create(MultiPartEmail.class);
        email.setSubject("[email] 5.Test: Subject with three greek UTF-8 characters : \u03b1\u03b2\u03b3");
        email.setMsg("My test body with with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n");
        ByteArrayDataSource attachment = new ByteArrayDataSource("My test body with with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n".getBytes("utf-8"), "text/plain");
        email.attach((DataSource)attachment, "\u03b1\u03b2\u03b3.txt", "Attachment in Greek");
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/correct-encoding.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }

    @Test
    public void testImageHtmlEmailLocal() throws Exception {
        File htmlFile = new File("./src/test/resources/html/www.apache.org.html");
        String htmlMsg1 = FileUtils.readFileToString((File)htmlFile, (String)"ISO-8859-1");
        ImageHtmlEmail email = (ImageHtmlEmail)this.create(ImageHtmlEmail.class);
        email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(htmlFile.getParentFile().toURI().toURL(), false));
        email.setSubject("[testImageHtmlEmail] 1.Test: simple html content");
        email.setHtmlMsg(htmlMsg1);
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/testImageHtmlEmailLocal.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }

    @Test
    public void testImageHtmlEmailRemote() throws Exception {
    }

    @Test
    public void testSendingEmailsInBatch() throws Exception {
        ArrayList<SimpleEmail> emails = new ArrayList<SimpleEmail>();
        Session session = this.create(SimpleEmail.class).getMailSession();
        Transport transport = session.getTransport();
        for (int i = 0; i < 3; ++i) {
            SimpleEmail personalizedEmail = (SimpleEmail)this.create(SimpleEmail.class);
            personalizedEmail.setMailSession(session);
            personalizedEmail.setSubject("Personalized Test Mail Nr. " + i);
            personalizedEmail.setMsg("This is a personalized test mail ... :-)");
            personalizedEmail.buildMimeMessage();
            emails.add(personalizedEmail);
        }
    }

    @Test
    public void testPartialSend() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.addTo("test_to@apache.org");
        email.addTo("nobody@is.invalid");
        email.setSubject("TestPartialMail");
        email.setMsg("This is a test mail ... :-)");
        email.setSendPartial(true);
        EmailUtils.writeMimeMessage((File)new File("./target/test-emails/partialmail.eml"), (MimeMessage)this.send((Email)email).getMimeMessage());
    }
}

