/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.lang.reflect.Method;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.AbstractEmailTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvalidInternetAddressTest
extends AbstractEmailTest {
    private static final String VALID_QUOTED_EMAIL = "\"John O'Groats\"@domain.com";
    private static Method validateMethod;
    private static final String[] ARR_INVALID_EMAILS;

    @Before
    public void setUpInvalidInternetAddressTest() {
        try {
            validateMethod = InternetAddress.class.getMethod("validate", new Class[0]);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got wrong Exception when looking for validate()", NoSuchMethodException.class, e.getClass());
        }
    }

    @Test
    public void testStrictConstructor() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                new InternetAddress(ARR_INVALID_EMAILS[i]);
                Assert.fail((String)("Strict " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            new InternetAddress(VALID_QUOTED_EMAIL);
        }
        catch (Exception ex) {
            Assert.fail((String)("Valid Quoted Email failed: \"John O'Groats\"@domain.com - " + ex.getMessage()));
        }
    }

    @Test
    public void testValidateMethod() throws Exception {
        if (validateMethod == null) {
            return;
        }
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            InternetAddress address = new InternetAddress(ARR_INVALID_EMAILS[i], "Joe");
            boolean quoted = ARR_INVALID_EMAILS[i].contains("\"");
            int atIndex = ARR_INVALID_EMAILS[i].indexOf("@");
            boolean domainBracket = atIndex >= 0 && ARR_INVALID_EMAILS[i].indexOf("[", atIndex) >= 0;
            try {
                validateMethod.invoke((Object)address, (Object[])null);
                if (quoted || domainBracket) continue;
                Assert.fail((String)("Validate " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (Exception ex) {
                if (!quoted && !domainBracket) continue;
                Assert.fail((String)("Validate " + i + " failed: " + ARR_INVALID_EMAILS[i] + " - " + ex.getMessage()));
            }
        }
        try {
            validateMethod.invoke((Object)new InternetAddress(VALID_QUOTED_EMAIL, "Joe"), (Object[])null);
        }
        catch (Exception ex) {
            Assert.fail((String)("Valid Quoted Email failed: \"John O'Groats\"@domain.com - " + ex.getMessage()));
        }
    }

    @Test
    public void testValidateMethodCharset() throws Exception {
        if (validateMethod == null) {
            return;
        }
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            InternetAddress address = new InternetAddress(ARR_INVALID_EMAILS[i], "Joe", "UTF-8");
            boolean quoted = ARR_INVALID_EMAILS[i].contains("\"");
            int atIndex = ARR_INVALID_EMAILS[i].indexOf("@");
            boolean domainBracket = atIndex >= 0 && ARR_INVALID_EMAILS[i].indexOf("[", atIndex) >= 0;
            try {
                validateMethod.invoke((Object)address, (Object[])null);
                if (quoted || domainBracket) continue;
                Assert.fail((String)("Validate " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (Exception ex) {
                if (!quoted && !domainBracket) continue;
                Assert.fail((String)("Validate " + i + " failed: " + ARR_INVALID_EMAILS[i] + " - " + ex.getMessage()));
            }
        }
        try {
            validateMethod.invoke((Object)new InternetAddress(VALID_QUOTED_EMAIL, "Joe", "UTF-8"), (Object[])null);
        }
        catch (Exception ex) {
            Assert.fail((String)("Valid Quoted Email failed: \"John O'Groats\"@domain.com - " + ex.getMessage()));
        }
    }

    static {
        ARR_INVALID_EMAILS = new String[]{"local name@domain.com", "local(name@domain.com", "local)name@domain.com", "local<name@domain.com", "local>name@domain.com", "local,name@domain.com", "local;name@domain.com", "local:name@domain.com", "local[name@domain.com", "local]name@domain.com", "local\tname@domain.com", "local\nname@domain.com", "local\rname@domain.com", "local.name@domain com", "local.name@domain(com", "local.name@domain)com", "local.name@domain<com", "local.name@domain>com", "local.name@domain,com", "local.name@domain;com", "local.name@domain:com", "local.name@domain]com", "local.name@domain\\com", "local.name@domain\tcom", "local.name@domain\ncom", "local.name@domain\rcom", "local.name@", "@domain.com"};
    }
}

