/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.apache.commons.mail.resolver.DataSourceCompositeResolver;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourceCompositeResolverTest
extends AbstractDataSourceResolverTest {
    private DataSourceResolver[] dataSourceResolvers;

    @Before
    public void setUp() throws Exception {
        DataSourceUrlResolver urlResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        DataSourceClassPathResolver classPathResolver = new DataSourceClassPathResolver("/images", false);
        this.dataSourceResolvers = new DataSourceResolver[]{urlResolver, classPathResolver};
    }

    @Test
    public void testResolvingFilesLenient() throws Exception {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolvers, true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("/contentTypeTest.gif")).length > 0 ? 1 : 0) != 0);
    }

    @Test(expected=IOException.class)
    public void testResolvingFilesNonLenient() throws Exception {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolvers, false);
        dataSourceResolver.resolve("./image/does-not-exist.gif");
    }

    @Test
    public void testExternalModification() throws Exception {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolvers, true);
        DataSourceResolver[] arr = dataSourceResolver.getDataSourceResolvers();
        arr[0] = null;
        DataSourceResolver[] arr2 = dataSourceResolver.getDataSourceResolvers();
        Assert.assertNotNull((Object)arr2[0]);
    }
}

