/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.model.dao.AbstractDao;
import at.itsv.tools.dao.GenericDaoImpl;
import at.itsv.tools.model.AbstractEntity;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;

public abstract class AbstractDaoImpl<ENTITY extends AbstractEntity, ID extends Serializable>
extends GenericDaoImpl<ENTITY, ID>
implements AbstractDao<ENTITY, ID> {
    protected abstract Logger getLog();

    protected Session getCurrentSession() {
        return (Session)this.getEntityManager().getDelegate();
    }

    protected Criteria buildBaseCriteria(Class<ENTITY> entityClass, List<Criterion> criterions, List<Order> orders) {
        this.getLog().debug("buildBaseCriteria() - start: entityClass: {}", entityClass);
        Criteria criteria = this.getCurrentSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                criteria.add(criterion);
            }
        }
        if (orders != null) {
            for (Order order : orders) {
                criteria.addOrder(order);
            }
        }
        criteria.setProjection(null);
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
        this.getLog().debug("buildBaseCriteria() - end");
        return criteria;
    }

    @Override
    public List<ENTITY> getByCriteria(Class<ENTITY> entityClass, List<Criterion> criterions, List<Order> orders) {
        this.getLog().debug("getByCriteria() - start");
        Criteria criteria = this.buildBaseCriteria(entityClass, criterions, orders);
        List entities = criteria.list();
        this.getLog().debug("getByCriteria() - end");
        return entities;
    }

    @Override
    public List<ENTITY> getByCriteria(Class<ENTITY> entityClass, List<Criterion> criterions, List<Order> orders, int startIndex, int pageSize) {
        this.getLog().debug("getByCriteria - start: startIndex {}; pageSize {}", (Object)startIndex, (Object)pageSize);
        Criteria criteria = this.buildBaseCriteria(entityClass, criterions, orders);
        criteria.setFirstResult(startIndex);
        criteria.setMaxResults(pageSize);
        List entities = criteria.list();
        this.getLog().debug("findByCriteriaPaged() - end");
        return entities;
    }

    @Override
    public int countByCriteria(Class<ENTITY> entityClass, List<Criterion> criterions) {
        this.getLog().debug("countByCriteria() - start");
        Criteria criteria = this.buildBaseCriteria(entityClass, criterions, null);
        criteria.setProjection(Projections.rowCount());
        int totalCount = ((Long)criteria.uniqueResult()).intValue();
        this.getLog().debug("countByCriteria() - finished, count is {}", (Object)totalCount);
        return totalCount;
    }
}

