/*
 * Decompiled with CFR 0.152.
 */
package at.sozvers.seucc.unicode.icu;

import at.sozvers.seucc.unicode.charsets.UnicodeSetSvFactory;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;

public class UnicodeTools {
    static boolean debug = false;

    public static String getUnicodeSetAsString(UnicodeSet unicodeSet) {
        StringBuffer buffer = new StringBuffer();
        UnicodeSetIterator it = new UnicodeSetIterator(unicodeSet);
        while (it.nextRange()) {
            if (it.codepoint == UnicodeSetIterator.IS_STRING) continue;
            for (int i = it.codepoint; i <= it.codepointEnd; ++i) {
                char c = (char)i;
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    public static String getCharacterSetName(char c) {
        String result = null;
        UnicodeSet set = UnicodeSetSvFactory.getBasicLatin();
        if (set.contains((int)c)) {
            result = "Basic Latin";
        } else {
            set = UnicodeSetSvFactory.getLatin1Supplement();
            if (set.contains((int)c)) {
                result = "Latin-1 Supplement";
            } else {
                set = UnicodeSetSvFactory.getLatinExtendedA();
                if (set.contains((int)c)) {
                    result = "Latin Extended A";
                } else {
                    set = UnicodeSetSvFactory.getLatinExtendedB();
                    if (set.contains((int)c)) {
                        result = "Latin Extended B";
                    } else {
                        set = UnicodeSetSvFactory.getLatinExtendedAdditional();
                        if (set.contains((int)c)) {
                            result = "Latin Extended Additional";
                        }
                    }
                }
            }
        }
        return result;
    }
}

