/*
 * Decompiled with CFR 0.152.
 */
package at.sozvers.seucc.unicode.subsetun;

import at.sozvers.seucc.unicode.UnicodeCharacter;
import at.sozvers.seucc.unicode.UnicodeCharacterSet;
import at.sozvers.seucc.unicode.eindeutschen.EindeutschenUtil;
import at.sozvers.seucc.unicode.subsetun.Transformer;
import at.sozvers.seucc.unicode.zpv.IZeichensatzPruefer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Validator
implements IZeichensatzPruefer {
    private static final Logger log = Logger.getLogger(Transformer.class);
    UnicodeCharacterSet characterSet = null;
    char[] ignoreCharacters = null;
    Charset charset = null;

    public Validator() {
        this.charset = Charset.forName("ISO-8859-15");
    }

    public Validator(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    @Override
    public int[] fehlerhaftePositionen(String value) {
        ArrayList<Integer> invalidPositionList = new ArrayList<Integer>();
        boolean isvalid = true;
        char[] valuechars = value.toCharArray();
        for (int i = 0; i < valuechars.length; ++i) {
            UnicodeCharacter unicodeChar;
            char mychar = valuechars[i];
            if (EindeutschenUtil.isMember(mychar, this.ignoreCharacters) || (unicodeChar = this.characterSet.get(mychar)) != null) continue;
            invalidPositionList.add(new Integer(i));
        }
        int[] invalidPositions = new int[invalidPositionList.size()];
        int i = 0;
        for (Integer position : invalidPositionList) {
            invalidPositions[i] = position;
            ++i;
        }
        return invalidPositions;
    }

    @Override
    public boolean pruefe(String value) {
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        boolean isvalid = true;
        char[] valuechars = value.toCharArray();
        for (int i = 0; i < valuechars.length && isvalid; ++i) {
            UnicodeCharacter unicodeChar;
            char mychar = valuechars[i];
            if (EindeutschenUtil.isMember(mychar, this.ignoreCharacters) || (unicodeChar = this.characterSet.get(mychar)) != null || charsetEncoder.canEncode(mychar)) continue;
            isvalid = false;
        }
        return isvalid;
    }

    @Override
    public Charset[] unterstuetzteCharsets() {
        return null;
    }

    public UnicodeCharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(UnicodeCharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    public char[] getIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(char[] ignoreCharacters) {
        this.ignoreCharacters = ignoreCharacters;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

