/*
 * Decompiled with CFR 0.152.
 */
package at.sozvers.seucc.unicode.util;

import at.sozvers.seucc.unicode.util.InvalidEntityNotationException;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class ConverterUtil {
    private static Logger log = Logger.getLogger(ConverterUtil.class);
    private static final String CLASSNAME = ConverterUtil.class.getName();

    public static String convertUnicodeTo7BitAscii(String unicodeString) {
        int minlength = (int)((double)unicodeString.length() * 1.1);
        StringBuffer buffer = new StringBuffer(minlength);
        for (int i = 0; i < unicodeString.length(); ++i) {
            char c = unicodeString.charAt(i);
            char charDezimal = c;
            if (charDezimal >= '\u0080') {
                String hex = Integer.toHexString(charDezimal);
                buffer.append("&#x" + hex + ";");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String convertEntityToUnicode(String entityString) throws InvalidEntityNotationException {
        StringBuffer buffer = new StringBuffer();
        int pos = 0;
        int lastPos = 0;
        pos = entityString.indexOf("&#x");
        log.debug((Object)("pos: " + pos));
        while (pos >= 0) {
            int nextPos;
            log.debug((Object)("lastPos: " + lastPos + " pos: " + pos));
            if (pos > lastPos) {
                String betweenOccurences = entityString.substring(lastPos, pos);
                log.debug((Object)("appending text dazwischen: " + betweenOccurences));
                buffer.append(betweenOccurences);
            }
            if ((nextPos = entityString.indexOf(";", pos)) > 0) {
                log.debug((Object)"begrenzer gefunden");
                String charcode = entityString.substring(pos + 3, nextPos);
                log.debug((Object)("charcode: " + charcode));
                try {
                    Integer charcodeDecimalInt = Integer.valueOf(charcode, 16);
                    int charcodeDecimal = charcodeDecimalInt;
                    buffer.append((char)charcodeDecimal);
                }
                catch (NumberFormatException e) {
                    throw new InvalidEntityNotationException("Die Ziffern zwischen &#x und ; sind kein korrekter Hex-String: " + charcode);
                }
            } else {
                throw new InvalidEntityNotationException("&#x-Folge wurde nicht mit ; abgeschlossen");
            }
            lastPos = nextPos + 1;
            pos = entityString.indexOf("&#x", lastPos);
        }
        int lastStringIndex = entityString.length();
        if (lastStringIndex > lastPos) {
            String afterOccurences = entityString.substring(lastPos, lastStringIndex);
            log.debug((Object)("appending: " + afterOccurences));
            buffer.append(afterOccurences);
        }
        return buffer.toString();
    }

    public static byte[] toUTF8ByteArray(String input) throws UnsupportedEncodingException {
        return input.getBytes("UTF-8");
    }

    public static byte[] toISO88591ByteArray(String input) throws UnsupportedEncodingException {
        return input.getBytes("ISO-8859-1");
    }

    public static String fromISO88591ToUnicode(byte[] input) throws UnsupportedEncodingException {
        return new String(input, "ISO-8859-1");
    }

    public static String fromUTF8ToUnicode(byte[] input) throws UnsupportedEncodingException {
        return new String(input, "UTF-8");
    }
}

