/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.logging;

import at.itsv.tools.errorhandling.TA3JApplicationException;
import at.itsv.tools.keyvalue.KeyValueUtils;
import at.itsv.tools.keyvalue.StringKeyValue;
import at.itsv.tools.logging.SVLogDefaults;
import at.itsv.tools.logging.SVLogLevel;
import at.itsv.tools.logging.SVLogger;
import at.itsv.tools.logging.keyvalue.DurationKeyValue;
import at.itsv.tools.logging.keyvalue.StringIdKeyValue;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.ext.LoggerWrapper;

public class SVLoggerImpl
extends LoggerWrapper
implements SVLogger,
Serializable {
    private static final long serialVersionUID = 1566622540989887639L;

    public SVLoggerImpl(Logger logger) {
        super(logger, LoggerWrapper.class.getName());
    }

    protected void doLog(String message, SVLogDefaults logDefault, List<StringKeyValue> appMdcParams, List<StringKeyValue> additionalMdcParams, Throwable fehler, Object ... args) {
        if (!this.logEnabled(logDefault.logLevel)) {
            return;
        }
        if (logDefault.defaultMdcParams != null) {
            for (StringKeyValue mdcParam : logDefault.defaultMdcParams) {
                MDC.put((String)((String)mdcParam.getKey()), (String)((String)mdcParam.getValue()));
            }
        }
        if (additionalMdcParams != null) {
            for (StringKeyValue mdcParam : additionalMdcParams) {
                MDC.put((String)((String)mdcParam.getKey()), (String)((String)mdcParam.getValue()));
            }
        }
        if (appMdcParams != null) {
            for (StringKeyValue mdcParam : appMdcParams) {
                MDC.put((String)((String)mdcParam.getKey()), (String)((String)mdcParam.getValue()));
            }
        }
        switch (logDefault.logLevel) {
            case DEBUG: {
                if (fehler != null) {
                    super.debug(message, fehler);
                    break;
                }
                super.debug(message, args);
                break;
            }
            case INFO: {
                if (fehler != null) {
                    super.info(message, fehler);
                    break;
                }
                super.info(message, args);
                break;
            }
            case ERROR: {
                if (fehler != null) {
                    super.error(message, fehler);
                    break;
                }
                super.error(message, args);
            }
        }
        if (appMdcParams != null) {
            for (StringKeyValue mdcParam : appMdcParams) {
                MDC.remove((String)((String)mdcParam.getKey()));
            }
        }
        if (additionalMdcParams != null) {
            for (StringKeyValue mdcParam : additionalMdcParams) {
                MDC.remove((String)((String)mdcParam.getKey()));
            }
        }
        if (logDefault.defaultMdcParams != null) {
            for (StringKeyValue mdcParam : logDefault.defaultMdcParams) {
                MDC.remove((String)((String)mdcParam.getKey()));
            }
        }
    }

    @Override
    public void debugging(String message, Object ... args) {
        this.debugging(message, null, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.debugging(message, args);
    }

    @Override
    public void debugging(String message, StringKeyValue ... mdcParams) {
        this.debugging(message, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), new Object[0]);
    }

    @Override
    public void debugging(String message, List<StringKeyValue> mdcParams, Object ... args) {
        this.doLog(message, SVLogDefaults.DEBUGGING, mdcParams, null, null, args);
    }

    @Override
    public void debugging(String message, TA3JApplicationException fehler, StringKeyValue ... mdcParams) {
        this.doLog(message, SVLogDefaults.DEBUGGING, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), null, (Throwable)fehler, new Object[0]);
    }

    @Override
    public void debugging(String message, Throwable fehler, StringKeyValue ... mdcParams) {
        this.doLog(message, SVLogDefaults.DEBUGGING, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), null, fehler, new Object[0]);
    }

    @Override
    public void tracing(String message, Object ... args) {
        this.tracing(message, null, args);
    }

    @Override
    public void tracing(String message, StringKeyValue ... mdcParams) {
        this.tracing(message, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), new Object[0]);
    }

    @Override
    public void tracing(String message, List<StringKeyValue> mdcParams, Object ... args) {
        this.doLog(message, SVLogDefaults.TRACING, mdcParams, null, null, args);
    }

    @Override
    public void tracing(String message, TA3JApplicationException fehler, StringKeyValue ... mdcParams) {
        if (fehler != null) {
            List additionalMdcParams = KeyValueUtils.transformVariableToList((StringKeyValue[])new StringKeyValue[]{new StringKeyValue("ErrorClass", fehler.getErrorClass()), new StringKeyValue("ErrorLogId", fehler.getLogId())});
            switch (fehler.getExceptionCategory()) {
                case FACHLICHERFEHLER: {
                    this.doLog(message, SVLogDefaults.TRACING, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), additionalMdcParams, (Throwable)fehler, new Object[0]);
                    break;
                }
                case SYSTEMFEHLER: {
                    if (fehler.getParams() != null && !fehler.getParams().isEmpty()) {
                        additionalMdcParams.addAll(fehler.getParams());
                    }
                    this.doLog(message, SVLogDefaults.SYSTEMFEHLER, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), additionalMdcParams, (Throwable)fehler, new Object[0]);
                }
            }
            return;
        }
        this.doLog(message, SVLogDefaults.TRACING, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), null, null, new Object[0]);
    }

    @Override
    public void tracing(String message, Throwable fehler, StringKeyValue ... mdcParams) {
        this.doLog(message, SVLogDefaults.SYSTEMFEHLER, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), null, fehler, new Object[0]);
    }

    @Override
    public void auditing(String message, Object ... args) {
        this.auditing(message, null, args);
    }

    @Override
    public void auditing(String message, StringKeyValue ... mdcParams) {
        this.auditing(message, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), new Object[0]);
    }

    @Override
    public void auditing(String message, List<StringKeyValue> mdcParams, Object ... args) {
        this.doLog(message, SVLogDefaults.AUDITING, mdcParams, null, null, args);
    }

    @Override
    public void monitoring(String message, Object ... args) {
        this.monitoring(message, null, args);
    }

    @Override
    public void monitoring(String message, StringKeyValue ... mdcParams) {
        this.monitoring(message, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), new Object[0]);
    }

    @Override
    public void monitoring(String message, List<StringKeyValue> mdcParams, Object ... args) {
        this.doLog(message, SVLogDefaults.MONITORING, mdcParams, null, null, args);
    }

    @Override
    public void monitoringPerformance(String message, long duration, String id, Object ... args) {
        this.monitoringPerformance(message, duration, id, null, args);
    }

    @Override
    public void monitoringPerformance(String message, long duration, String id, StringKeyValue ... mdcParams) {
        this.monitoringPerformance(message, duration, id, KeyValueUtils.transformVariableToList((StringKeyValue[])mdcParams), new Object[0]);
    }

    @Override
    public void monitoringPerformance(String message, long duration, String id, List<StringKeyValue> mdcParams, Object ... args) {
        if (id != null) {
            this.doLog(message, SVLogDefaults.MONITORING_PERFORMANCE, mdcParams, KeyValueUtils.transformVariableToList((StringKeyValue[])new StringKeyValue[]{new DurationKeyValue(duration), new StringIdKeyValue(id)}), null, args);
        } else {
            this.doLog(message, SVLogDefaults.MONITORING_PERFORMANCE, mdcParams, KeyValueUtils.transformVariableToList((StringKeyValue[])new StringKeyValue[]{new DurationKeyValue(duration)}), null, args);
        }
    }

    @Override
    public boolean isDebuggingEnabled() {
        return super.isDebugEnabled();
    }

    private boolean logEnabled(SVLogLevel level) {
        if (level == SVLogLevel.DEBUG && super.isDebugEnabled()) {
            return true;
        }
        if (level == SVLogLevel.INFO && super.isInfoEnabled()) {
            return true;
        }
        return level == SVLogLevel.ERROR && super.isErrorEnabled();
    }
}

