/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.invoker;

import at.itsv.tools.invoker.WebServiceAufrufParameter;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.properties.DynamicProperty;
import at.itsv.tools.properties.DynamicPropertyHelper;
import at.itsv.tools.properties.DynamicPropertyWebService;
import at.itsv.tools.properties.JNDINameHelper;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.slf4j.Logger;

@ApplicationScoped
public class WebServiceAufrufHelper
implements Serializable {
    private static final long serialVersionUID = 923926414013183967L;
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    private DynamicPropertyHelper dspHelper;

    private <T> String getNamespace(Class<T> serviceInterface, WebServiceAufrufParameter webServiceAufrufParameter) {
        String namespace;
        String serviceNamespace = this.dspHelper.getValue((DynamicProperty)DynamicPropertyWebService.NAMESPACE, JNDINameHelper.JNDINameNotFoundStrategy.LOG_DEBUG, new String[]{webServiceAufrufParameter.getWebServicePropertiesPrefix(), serviceInterface.getSimpleName()});
        String defaultNamespace = webServiceAufrufParameter.getWebServiceNamespace();
        if (serviceNamespace != null) {
            namespace = serviceNamespace;
        } else if (defaultNamespace != null) {
            namespace = defaultNamespace;
        } else {
            throw new IllegalStateException("Kein Namepsace f\u00fcr das Backend-Service " + serviceInterface.getSimpleName() + " in den Properties definiert!");
        }
        return namespace;
    }

    private QName getQName(Class<?> serviceInterface, DynamicPropertyWebService dynamicWebServiceProperty, WebServiceAufrufParameter webServiceAufrufParameter) {
        return new QName(this.getNamespace(serviceInterface, webServiceAufrufParameter), this.dspHelper.getValue((DynamicProperty)dynamicWebServiceProperty, new String[]{webServiceAufrufParameter.getWebServicePropertiesPrefix(), serviceInterface.getSimpleName()}));
    }

    public <T> T getService(Class<T> serviceInterface, WebServiceAufrufParameter webServiceAufrufParameter) throws MalformedURLException {
        if (serviceInterface == null) {
            throw new IllegalArgumentException("serviceInterface should be Class<T> not null");
        }
        if (webServiceAufrufParameter == null) {
            throw new IllegalArgumentException("webServiceAufrufParameter should be WebServiceAufrufParameter not null");
        }
        URL wsdlLocation = this.getUrlFor(serviceInterface, DynamicPropertyWebService.WSDL_LOCATION, webServiceAufrufParameter);
        URL webServiceLocation = this.getUrlFor(serviceInterface, DynamicPropertyWebService.WEBSERVICE_LOCATION, webServiceAufrufParameter);
        QName qNameService = this.getQName(serviceInterface, DynamicPropertyWebService.QNAME_SERVICE, webServiceAufrufParameter);
        QName qNamePort = this.getQName(serviceInterface, DynamicPropertyWebService.QNAME_PORT, webServiceAufrufParameter);
        this.log.info("Erstelle WebService-Verbindung mit folgenden Daten:");
        this.log.info("    wsdlLocation: " + wsdlLocation);
        this.log.info("    webServiceLocation: " + webServiceLocation);
        this.log.info("    qNameService: " + qNameService);
        this.log.info("    qNamePort: " + qNamePort);
        Object service = Service.create((URL)wsdlLocation, (QName)qNameService).getPort(qNamePort, serviceInterface);
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.service.endpoint.address", webServiceLocation.toString());
        return (T)service;
    }

    private <T> URL getUrlFor(Class<T> serviceInterface, DynamicPropertyWebService dynamicWebServiceProperty, WebServiceAufrufParameter webServiceAufrufParameter) throws MalformedURLException {
        String serviceURL = this.dspHelper.getValue((DynamicProperty)DynamicPropertyWebService.URL, JNDINameHelper.JNDINameNotFoundStrategy.LOG_DEBUG, new String[]{webServiceAufrufParameter.getWebServicePropertiesPrefix(), serviceInterface.getSimpleName()});
        String defaultURL = webServiceAufrufParameter.getWebServiceURL();
        StringBuilder completeURL = new StringBuilder();
        if (serviceURL != null) {
            completeURL.append(serviceURL);
        } else if (defaultURL != null) {
            completeURL.append(defaultURL);
        } else {
            throw new IllegalStateException("Keine URL f\u00fcr das Backend-Service " + serviceInterface.getSimpleName() + " in den Properties definiert!");
        }
        completeURL.append(this.dspHelper.getValue((DynamicProperty)dynamicWebServiceProperty, new String[]{webServiceAufrufParameter.getWebServicePropertiesPrefix(), serviceInterface.getSimpleName()}));
        return new URL(completeURL.toString());
    }
}

