/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.io;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.properties.DynamicProperty;
import at.itsv.tools.properties.DynamicPropertyHelper;
import at.itsv.tools.properties.JNDINameHelper;
import at.itsv.tools.services.io.DynamicPropertyStandardRequest;
import at.itsv.tools.services.io.StandardRequest;
import at.itsv.tools.services.io.Systemmodus;
import at.itsv.tools.services.io.TransaktionsIDGenerator;
import at.itsv.tools.services.io.Verarbeitungsmodus;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class StandardRequestHelperBackend {
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    private DynamicPropertyHelper dynamicPropertyHelper;
    @Inject
    private TransaktionsIDGenerator transaktionsIDGenerator;

    public StandardRequest fillAll(StandardRequest request, String jndiPrefix) {
        this.fillNonBearbeiterFields(request, jndiPrefix, null);
        this.fillBearbeiterFieldsViaProperties(request, jndiPrefix, null);
        return request;
    }

    public StandardRequest fillAll(StandardRequest request, String jndiPrefix, String serviceName) {
        this.fillNonBearbeiterFields(request, jndiPrefix, serviceName);
        this.fillBearbeiterFieldsViaProperties(request, jndiPrefix, serviceName);
        return request;
    }

    public StandardRequest fillNonBearbeiterFields(StandardRequest request, String jndiPrefix, String serviceName) {
        request.getHeader().setApplikationsID(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.APPLIKATIONSID, jndiPrefix, serviceName));
        request.getHeader().setSystemmodus(this.convertToSystemModus(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.SYSTEMMODUS, jndiPrefix, serviceName)));
        request.getHeader().setVerarbeitungsmodus(this.convertToVerarbeitungsmodus(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.VERARBEITUNGSMODUS, jndiPrefix, serviceName)));
        this.transaktionsIDGenerator.setTransaktionsID(request);
        return request;
    }

    public StandardRequest fillBearbeiterFieldsViaProperties(StandardRequest request, String jndiPrefix, String serviceName) {
        request.getHeader().getBearbeiter().setBearbeiterID(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_BEARBEITERID, jndiPrefix, serviceName));
        request.getHeader().getBearbeiter().setBearbeitungsgrund(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_BEARBEITUNGSGRUND, jndiPrefix, serviceName));
        request.getHeader().getBearbeiter().setMeldendeStelle(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_MELDENDESTELLE, jndiPrefix, serviceName));
        request.getHeader().getBearbeiter().setOrgeinheitID(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_ORGEINHEITID, jndiPrefix, serviceName));
        request.getHeader().getBearbeiter().setTraegerID(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_TRAEGERID, jndiPrefix, serviceName));
        request.getHeader().getBearbeiter().setBenutzerkreis(this.getDefaultOrConcreteValue(DynamicPropertyStandardRequest.BEARBETIER_BENUTZERKREIS, jndiPrefix, serviceName));
        return request;
    }

    public StandardRequest copy(StandardRequest from, StandardRequest to) {
        to.getHeader().setApplikationsID(from.getHeader().getApplikationsID());
        to.getHeader().setSystemmodus(from.getHeader().getSystemmodus());
        to.getHeader().setTransaktionsID(from.getHeader().getTransaktionsID());
        to.getHeader().setVerarbeitungsmodus(from.getHeader().getVerarbeitungsmodus());
        to.getHeader().getBearbeiter().setBearbeiterID(from.getHeader().getBearbeiter().getBearbeiterID());
        to.getHeader().getBearbeiter().setBearbeitungsgrund(from.getHeader().getBearbeiter().getBearbeitungsgrund());
        to.getHeader().getBearbeiter().setMeldendeStelle(from.getHeader().getBearbeiter().getMeldendeStelle());
        to.getHeader().getBearbeiter().setOrgeinheitID(from.getHeader().getBearbeiter().getOrgeinheitID());
        to.getHeader().getBearbeiter().setTraegerID(from.getHeader().getBearbeiter().getTraegerID());
        to.getHeader().getBearbeiter().setBenutzerkreis(from.getHeader().getBearbeiter().getBenutzerkreis());
        return to;
    }

    private String getDefaultOrConcreteValue(DynamicPropertyStandardRequest property, String jndiPrefix, String serviceName) {
        String returnValue = "";
        String defaultValue = this.dynamicPropertyHelper.getValue((DynamicProperty)property, JNDINameHelper.JNDINameNotFoundStrategy.NOTHING, new String[]{jndiPrefix});
        String concreteValue = this.dynamicPropertyHelper.getValue((DynamicProperty)property, JNDINameHelper.JNDINameNotFoundStrategy.NOTHING, new String[]{jndiPrefix, serviceName});
        returnValue = concreteValue != null && !"".equals(concreteValue) ? concreteValue : defaultValue;
        if (returnValue == null || "".equals(returnValue)) {
            this.log.warn("no JNDI-value found for " + (Object)((Object)property) + ", jndiPrefix: " + jndiPrefix + ", serviceName: " + serviceName);
        }
        return returnValue;
    }

    private Systemmodus convertToSystemModus(String value) {
        if (value == null || "".equals(value) || value.length() > 1) {
            throw new IllegalArgumentException("value must be a single character but is '" + value + "'");
        }
        return Systemmodus.valueOf((char)value.charAt(0));
    }

    private Verarbeitungsmodus convertToVerarbeitungsmodus(String value) {
        if (value == null || "".equals(value) || value.length() > 1) {
            throw new IllegalArgumentException("value must be a single character but is '" + value + "'");
        }
        return Verarbeitungsmodus.valueOf((char)value.charAt(0));
    }
}

