/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.io;

import at.itsv.tools.services.io.StandardRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class TransaktionsIDGenerator {
    private final List<Character> symbols = new ArrayList<Character>();
    private final Random random = new Random();

    @PostConstruct
    private void init() {
        this.symbols.addAll(this.createSymbols('0', '9'));
        this.symbols.addAll(this.createSymbols('a', 'z'));
        this.symbols.addAll(this.createSymbols('A', 'Z'));
    }

    private List<Character> createSymbols(char from, char to) {
        ArrayList<Character> mysymbols = new ArrayList<Character>();
        for (int i = (int)from; i <= (byte)to; ++i) {
            mysymbols.add(Character.valueOf((char)i));
        }
        return mysymbols;
    }

    public String generateTransaktionsID() {
        return this.nextString(13);
    }

    private String nextString(int length) {
        StringBuilder sb = new StringBuilder(this.symbols.size());
        for (int i = 0; i < length; ++i) {
            sb.append(this.symbols.get(this.random.nextInt(this.symbols.size())));
        }
        return sb.toString();
    }

    public void setTransaktionsID(StandardRequest request) {
        request.getHeader().setTransaktionsID(this.generateTransaktionsID());
    }
}

