/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.cdi;

import at.itsv.tools.services.cdi.BeanManagerHelper;
import at.itsv.tools.services.cdi.ServiceAccess;
import at.itsv.tools.services.cdi.ServiceContext;
import at.itsv.tools.services.io.StandardRequest;
import at.itsv.tools.services.io.StandardResponse;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WithinServiceScope {
    private final Logger log = LoggerFactory.getLogger(WithinServiceScope.class);
    private final Class<? extends StandardResponse> responseClass;
    private final StandardResponse response;

    public WithinServiceScope(Class<? extends StandardResponse> responseClass, StandardRequest request) {
        if (responseClass == null) {
            throw new IllegalArgumentException("Prameter responseClass darf nicht NULL sein.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Prameter request darf nicht NULL sein.");
        }
        this.responseClass = responseClass;
        this.response = this.createResponse();
    }

    protected abstract void runWithinServiceScope() throws Exception;

    public Object execute() {
        ServiceContext.run(new Runnable(){

            @Override
            public void run() {
                ServiceAccess serviceAccess = BeanManagerHelper.getFromCDI(ServiceAccess.class, new Annotation[0]);
                serviceAccess.setResponse(WithinServiceScope.this.response);
                try {
                    WithinServiceScope.this.runWithinServiceScope();
                }
                catch (Exception e) {
                    WithinServiceScope.this.log.error(e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        });
        return this.response;
    }

    private StandardResponse createResponse() {
        StandardResponse newresponse = null;
        try {
            newresponse = this.responseClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
        return newresponse;
    }
}

