/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter;

import at.itsv.tools.services.cdi.BeanManagerHelper;
import at.itsv.tools.services.cdi.ServiceAccess;
import at.itsv.tools.services.converter.MeldungenErstellen;
import at.itsv.tools.services.converter.meldungen.ExceptionMeldungMapper;
import at.itsv.tools.services.converter.meldungen.MappedMeldung;
import at.itsv.tools.services.converter.meldungen.mapper.ExceptionMapper;
import javax.ejb.EJBException;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeldungenErstellen
@Interceptor
public class MeldungenErstellenInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(BeanManagerHelper.class);
    @Inject
    private ServiceAccess serviceAccess;
    @Inject
    private ExceptionMeldungMapper exceptionMeldungMapper;
    @Inject
    private ExceptionMapper defaultExceptionMapper;

    @AroundInvoke
    public Object convertExceptionToMeldungen(InvocationContext ctx) throws Exception {
        Object result = null;
        try {
            try {
                result = ctx.proceed();
            }
            catch (EJBException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e.getCausedByException();
            }
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            ExceptionMapper exceptionMapper = this.exceptionMeldungMapper.getFor(exception);
            if (exceptionMapper == null) {
                exceptionMapper = this.defaultExceptionMapper;
            }
            for (MappedMeldung meldungInternal : exceptionMapper.createMeldungen(exception, ctx)) {
                this.serviceAccess.getMeldungen().addMeldung(meldungInternal.getMeldung());
            }
        }
        return result;
    }
}

