/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class ExceptionMapperSorter {
    @Inject
    @SLF4J
    private Logger log;

    public List<AbstractExceptionMapper<? extends Exception>> sort(List<AbstractExceptionMapper<? extends Exception>> mapperExceptionList) {
        ArrayList<AbstractExceptionMapper<? extends Exception>> sorted = new ArrayList<AbstractExceptionMapper<? extends Exception>>();
        ArrayList<Class<? extends Exception>> customTypes = new ArrayList<Class<? extends Exception>>();
        while (sorted.size() < mapperExceptionList.size()) {
            for (AbstractExceptionMapper<? extends Exception> mapperException : mapperExceptionList) {
                if (sorted.contains(mapperException) || this.isSuperclassOfAnyElement(mapperException.getExceptionClass(), mapperExceptionList, sorted)) continue;
                sorted.add(mapperException);
                if (mapperException.isDefault()) continue;
                customTypes.add(mapperException.getExceptionClass());
            }
        }
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            AbstractExceptionMapper exceptionMapper = (AbstractExceptionMapper)iter.next();
            if (!exceptionMapper.isDefault() || !customTypes.contains(exceptionMapper.getExceptionClass())) continue;
            iter.remove();
        }
        this.logExceptionMappers(sorted);
        return sorted;
    }

    private void logExceptionMappers(List<AbstractExceptionMapper<? extends Exception>> mapperExceptionList) {
        if (this.log.isInfoEnabled()) {
            this.log.info("registered ExceptionMappers:");
            for (AbstractExceptionMapper<? extends Exception> abstractExceptionMapper : mapperExceptionList) {
                this.log.info("    " + abstractExceptionMapper.getClass().getName() + " -> " + abstractExceptionMapper.getExceptionClass().getName());
            }
        }
    }

    private boolean isSuperclassOfAnyElement(Class<?> clazz, List<AbstractExceptionMapper<? extends Exception>> mapperExceptionList, List<AbstractExceptionMapper<? extends Exception>> sorted) {
        boolean isSuperclassOfAnyElement = false;
        for (AbstractExceptionMapper<? extends Exception> mapperException : mapperExceptionList) {
            if (sorted.contains(mapperException) || clazz == mapperException.getExceptionClass() || !clazz.isAssignableFrom(mapperException.getExceptionClass())) continue;
            isSuperclassOfAnyElement = true;
            break;
        }
        return isSuperclassOfAnyElement;
    }
}

