/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.tools.services.converter.meldungen;

import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.services.converter.meldungen.ExceptionMapperSorter;
import at.itsv.tools.services.converter.meldungen.mapper.AbstractExceptionMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class ExceptionMeldungMapper {
    @Inject
    @SLF4J
    private Logger log;
    @Inject
    @Any
    private Instance<AbstractExceptionMapper<? extends Exception>> exceptionMapperInjections;
    private List<AbstractExceptionMapper<? extends Exception>> exceptionMapperList = new ArrayList<AbstractExceptionMapper<? extends Exception>>();
    @Inject
    private ExceptionMapperSorter exceptionMapperSorter;

    @PostConstruct
    public void registerAllMapperExceptions() {
        for (AbstractExceptionMapper exceptionMapper : this.exceptionMapperInjections) {
            this.exceptionMapperList.add(exceptionMapper);
            this.log.info("added to exception mapper: {}", (Object)exceptionMapper);
        }
        this.exceptionMapperList = this.exceptionMapperSorter.sort(this.exceptionMapperList);
    }

    public AbstractExceptionMapper<? extends Exception> getFor(Exception exception) {
        this.log.info("getting mapper for exception {}", (Throwable)exception);
        AbstractExceptionMapper<? extends Exception> result = null;
        for (AbstractExceptionMapper<? extends Exception> exceptionMapper : this.exceptionMapperList) {
            if (!exceptionMapper.canHandle(exception.getClass())) continue;
            result = exceptionMapper;
            break;
        }
        this.log.info("returning mapper {}", result);
        return result;
    }
}

