/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.dto.QsEintragDTO;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001;
import at.itsv.kfoqsdb.data.entities.zup.Ge1001Id;
import at.itsv.kfoqsdb.internal.enums.LogTypeEnum;
import at.itsv.kfoqsdb.internal.utils.ContextUtils;
import at.itsv.kfoqsdb.internal.utils.StringUtil;
import at.itsv.kfoqsdb.model.dao.HvbProtokollDAO;
import at.itsv.kfoqsdb.model.dao.HvbProtokollService;
import at.itsv.tools.logging.SLF4J;
import java.io.Serializable;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;

@Stateless
public class HvbProtokollServiceImpl
implements HvbProtokollService,
Serializable {
    private static final long serialVersionUID = -7698289767327291281L;
    public static final DateTimeFormatter DATUMSPROTOKOLL_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    public static final DateTimeFormatter ZEITPROTOKOLL_FORMAT = DateTimeFormat.forPattern((String)"HHmmssSSS");
    public static final String VERSIONPROTOKOLL = "0010";
    private ContextUtils contextUtils = new ContextUtils();
    @Inject
    @SLF4J
    private Logger logger;
    @Inject
    private HvbProtokollDAO hvbProtokollDAO;

    private Ge1001 initProtokollEntity(String user) {
        Ge1001Id id = new Ge1001Id();
        id.setProjekt("KF");
        LocalDateTime now = LocalDateTime.now();
        id.setTransactionid(this.createTransaction());
        id.setDatumprotokoll(now.toString(DATUMSPROTOKOLL_FORMAT));
        id.setZeitprotokoll(now.toString(ZEITPROTOKOLL_FORMAT));
        Ge1001 entry = new Ge1001();
        entry.setId(id);
        entry.setLogcode("V");
        entry.setSystemmodus(this.getEnviormentType());
        entry.setVersionprotokoll(VERSIONPROTOKOLL);
        entry.setZieltraegerid("99");
        entry.setVerarbeitungsmodus("O");
        entry.setBenutzerid(user);
        return entry;
    }

    @Override
    public void protokolliereUIZugriff(String tragercode, String username, QsEintragDTO qsEintrag, LogTypeEnum logType) {
        Ge1001 entry = this.initUIProtokoll(tragercode, username, logType);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)qsEintrag.getVsnr(), (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)qsEintrag.getVpnr(), (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    @Override
    public void protokolliereReportDownload(String tragercode, String username, Long reportId) {
        Ge1001 entry = this.initUIProtokoll(tragercode, username, LogTypeEnum.KFOQRD);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)Long.toString(reportId), (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    @Override
    public void protokolliereImportDownload(String tragercode, String username, Long fileUploadID) {
        Ge1001 entry = this.initUIProtokoll(tragercode, username, LogTypeEnum.KFODL);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)Long.toString(fileUploadID), (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    @Override
    public void protokolliereUIZugriff(String tragercode, String username, String value1, String value2, LogTypeEnum logType) {
        Ge1001 entry = this.initUIProtokoll(tragercode, username, logType);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)value1, (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)value2, (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    private Ge1001 initUIProtokoll(String tragercode, String username, LogTypeEnum logType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createEntry() -  Starting protocoll");
        }
        Ge1001 entry = this.initProtokollEntity(username);
        entry.getId().setLogid(logType.name());
        entry.setTraegerid(tragercode);
        entry.setBenutzerid(username);
        entry.setAppid("KFOQSDB");
        return entry;
    }

    @Override
    public void protokolliereKFOBOXZugriff(String userTraeger, String value1, String value2, String value3, LogTypeEnum logType, LocalDateTime logTime) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createEntry() -  Starting protocoll");
        }
        Ge1001 entry = this.initProtokollEntity(userTraeger);
        entry.getId().setLogid(logType.name());
        entry.setTraegerid("");
        entry.setAppid("KFOBOX");
        entry.getId().setDatumprotokoll(logTime.toString(DATUMSPROTOKOLL_FORMAT));
        entry.getId().setZeitprotokoll(logTime.toString(ZEITPROTOKOLL_FORMAT));
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)value1, (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)value2, (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)value3, (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    @Override
    public void protokolliereSearch(String tragercode, String username, String vpnr, String vsnr, String leName) {
        boolean leNameEmpty;
        boolean vsnrEmpty = vsnr == null || vsnr.length() == 0;
        boolean vpnrEmpty = vpnr == null || vpnr.length() == 0;
        boolean bl = leNameEmpty = leName == null || leName.length() == 0;
        if (vsnrEmpty && vpnrEmpty && leNameEmpty) {
            this.protokolliereDefaultNoParameterSearch(tragercode, username);
        } else if (!vpnrEmpty && vsnrEmpty) {
            this.protokolliereTwoParameterSearch(tragercode, username, vpnr, leName);
        } else if (vpnrEmpty && !vsnrEmpty) {
            this.protokolliereTwoParameterSearch(tragercode, username, vsnr, leName);
        } else if (!vpnrEmpty && !vsnrEmpty && leNameEmpty) {
            this.protokolliereTwoParameterSearch(tragercode, username, vsnr, vpnr);
        } else if (vpnrEmpty && vsnrEmpty && !leNameEmpty) {
            this.protokolliereTwoParameterSearch(tragercode, username, leName, "");
        } else if (!(vpnrEmpty || vsnrEmpty || leNameEmpty)) {
            this.protokolliereThreeParameterSearch(tragercode, username, vsnr, vpnr, leName);
        }
    }

    private Ge1001 initProtokollSearch(String tragercode, String username) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createEntry() -  Starting protocoll");
        }
        Ge1001 entry = this.initProtokollEntity(username);
        entry.getId().setLogid(LogTypeEnum.KFOQES.name());
        entry.setTraegerid(tragercode);
        entry.setBenutzerid(username);
        entry.setAppid("KFOQSDB");
        return entry;
    }

    private void protokolliereTwoParameterSearch(String tragercode, String username, String value1, String value2) {
        Ge1001 entry = this.initProtokollSearch(tragercode, username);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)value1, (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)value2, (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    private void protokolliereThreeParameterSearch(String tragercode, String username, String value1, String value2, String value3) {
        Ge1001 entry = this.initProtokollSearch(tragercode, username);
        entry.setAuswahlkriterium1(StringUtil.truncateAndRemoveSpacesFromString((String)value1, (int)20, (boolean)false));
        entry.setAuswahlkriterium2(StringUtil.truncateAndRemoveSpacesFromString((String)value2, (int)20, (boolean)false));
        entry.setAuswahlkriterium3(StringUtil.truncateAndRemoveSpacesFromString((String)value3, (int)20, (boolean)false));
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    private void protokolliereDefaultNoParameterSearch(String tragercode, String username) {
        Ge1001 entry = this.initProtokollSearch(tragercode, username);
        entry.setAuswahlkriterium1(tragercode);
        this.hvbProtokollDAO.saveOrUpdate(entry);
    }

    private String createTransaction() {
        return UUID.randomUUID().toString().substring(0, 12);
    }

    private String getEnviormentType() {
        try {
            return (String)InitialContext.doLookup("java:global/at/itsv/kfoqsdb/environment");
        }
        catch (NamingException e) {
            this.logger.error("environment Systemvariable wurde nicht gesetzt!");
            throw new IllegalStateException("Systemvariable nicht gesetzt!");
        }
    }
}

