/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.Notification;
import at.itsv.kfoqsdb.model.dao.NotificationDao;
import at.itsv.kfoqsdb.model.dao.impl.AbstractDaoImpl;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.model.AbstractBaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;

@Stateless
public class NotificationDaoImpl
extends AbstractDaoImpl<Notification, Long>
implements NotificationDao,
Serializable {
    @Inject
    @SLF4J
    private Logger log;

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public Class getManagedClass() {
        return Notification.class;
    }

    @Override
    public void saveOrUpdate(Notification notification) {
        this.log.debug("saveOrUpdate() - start");
        if (notification.getId() == null) {
            this.log.debug("saveOrUpdate() - saving new notification");
            this.save((AbstractBaseEntity)notification);
        } else {
            this.log.debug("saveOrUpdate() - updating existing notification with id: {}", (Object)notification.getId());
            this.update((AbstractBaseEntity)notification);
        }
        this.log.debug("saveOrUpdate() - end");
    }

    @Override
    public List<Notification> getNotificationsForTraeger(String traegerCode) {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add((Criterion)Restrictions.eq((String)"traeger", (Object)traegerCode));
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(Order.desc((String)"erstelldatum"));
        orders.add(Order.desc((String)"id"));
        return this.getByCriteria(Notification.class, (List<Criterion>)criterions, (List<Order>)orders);
    }

    @Override
    public int countUnreadNotificationsForTraeger(String traegerCode) {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add((Criterion)Restrictions.eq((String)"traeger", (Object)traegerCode));
        criterions.add((Criterion)Restrictions.eq((String)"gelesen", (Object)false));
        return this.countByCriteria(Notification.class, (List<Criterion>)criterions);
    }
}

