/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao.impl;

import at.itsv.kfoqsdb.data.entities.InvolvierteTraeger;
import at.itsv.kfoqsdb.data.entities.QsEintrag;
import at.itsv.kfoqsdb.data.entities.dto.ClearingDTO;
import at.itsv.kfoqsdb.internal.enums.LeistungsartEnum;
import at.itsv.kfoqsdb.model.dao.QsEintragDao;
import at.itsv.kfoqsdb.model.dao.impl.AbstractDaoImpl;
import at.itsv.tools.logging.SLF4J;
import at.itsv.tools.model.AbstractBaseEntity;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.slf4j.Logger;

@Stateless
public class QsEintragDaoImpl
extends AbstractDaoImpl<QsEintrag, Long>
implements QsEintragDao,
Serializable {
    @Inject
    @SLF4J
    private Logger log;

    @Override
    public Logger getLog() {
        return this.log;
    }

    public Class<QsEintrag> getManagedClass() {
        return QsEintrag.class;
    }

    @Override
    public void saveOrUpdate(QsEintrag qsEintrag) {
        this.log.debug("saveOrUpdate() - start");
        if (qsEintrag.getId() == null) {
            this.log.debug("saveOrUpdate() - saving new qsEintrag");
            this.save((AbstractBaseEntity)qsEintrag);
        } else {
            this.log.debug("saveOrUpdate() - updating existing qsEintrag with id: {}", (Object)qsEintrag.getId());
            this.update((AbstractBaseEntity)qsEintrag);
        }
        this.log.debug("saveOrUpdate() - end");
    }

    @Override
    public boolean isReadable(String vsnr, String traegerCode) {
        String queryString = "select case when exists (select distinct \"VsNr\" from kfoqsdb.\"QsEintrag\" where \"VsNr\" = '" + vsnr + "' and (\"QSTraeger\" = '" + traegerCode + "' or \"LZTraeger\" = '" + traegerCode + "' or \"ABRTraeger\" = '" + traegerCode + "'))Then CAST(1 AS BIT) ELSE CAST(0 AS BIT) END";
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryString);
        Object result = query.uniqueResult();
        return (Boolean)result;
    }

    private Criteria buildQsEntriesVisibleForTraegerCriteria(List<Criterion> criterions, List<Order> orders, String traegerCode) {
        DetachedCriteria userSubquery = DetachedCriteria.forClass(InvolvierteTraeger.class, (String)"ud").add((Criterion)Restrictions.eq((String)"ud.involvierteTraegerId.traegerCode", (Object)traegerCode)).setProjection((Projection)Projections.property((String)"ud.involvierteTraegerId.vsnr"));
        Criteria criteria = this.getCurrentSession().createCriteria(QsEintrag.class);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                criteria.add(criterion);
            }
        }
        if (orders != null) {
            for (Order order : orders) {
                criteria.addOrder(order);
            }
        }
        criteria.setProjection(null);
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
        criteria.add(Subqueries.propertyIn((String)"vsnr", (DetachedCriteria)userSubquery));
        return criteria;
    }

    @Override
    public List<QsEintrag> getQsEntriesVisibleForTraeger(List<Criterion> criterions, List<Order> orders, String traegerCode) {
        this.getLog().debug("getQsEntriesVisibleForTraeger - start: traegerCode {}", (Object)traegerCode);
        Criteria criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, orders, traegerCode);
        criteria.addOrder(Order.asc((String)"id"));
        List entities = criteria.list();
        this.getLog().debug("getQsEntriesVisibleForTraeger() - end");
        return entities;
    }

    @Override
    public List<ClearingDTO> getDuplicateQsEntriesForTraeger(String traegerCode) {
        this.getLog().debug("getDuplicateQsEntriesForTraeger - start: traegerCode {}", (Object)traegerCode);
        String sql = "select \"Leistungsart\", \"VpNr\", \"VsNr\", \"ABRTraeger\" from \"QsEintrag\"\nWHERE \"StornoDatum\" IS NULL AND \"ABRTraeger\" ='" + traegerCode + "' group by 1,2,3,4\nhaving count(*) > 1";
        SQLQuery query = this.getCurrentSession().createSQLQuery(sql);
        query.addScalar("Leistungsart", (Type)new StringType()).addScalar("VpNr", (Type)new StringType()).addScalar("VsNr", (Type)new StringType()).addScalar("ABRTraeger", (Type)new StringType()).setResultTransformer(Transformers.aliasToBean(ClearingDTO.class));
        List list = query.list();
        this.getLog().debug("getDuplicateQsEntriesForTraeger() - end");
        return list;
    }

    @Override
    public List<QsEintrag> getQsEntriesVisibleForTraeger(List<Criterion> criterions, List<Order> orders, int startIndex, int pageSize, String traegerCode) {
        this.getLog().debug("getQsEntriesVisibleForTraeger - start: startIndex {}; pageSize {}; traegerCode {}", new Object[]{startIndex, pageSize, traegerCode});
        Criteria criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, orders, traegerCode);
        criteria.addOrder(Order.asc((String)"id"));
        criteria.setFirstResult(startIndex);
        criteria.setMaxResults(pageSize);
        List entities = criteria.list();
        this.getLog().debug("getQsEntriesVisibleForTraeger() - end");
        return entities;
    }

    @Override
    public int countQsEntriesVisibleForTraeger(List<Criterion> criterions, String traegerCode) {
        this.getLog().debug("countQsEntriesVisibleForTraeger() - start");
        Criteria criteria = this.buildQsEntriesVisibleForTraegerCriteria(criterions, null, traegerCode);
        criteria.setProjection(Projections.rowCount());
        int totalCount = ((Long)criteria.uniqueResult()).intValue();
        this.getLog().debug("countQsEntriesVisibleForTraeger() - finished, count is {}", (Object)totalCount);
        return totalCount;
    }

    @Override
    public List<QsEintrag> getQsByKey(String vsnr, String vpnr, String abrTraeger, LeistungsartEnum leistungsart) {
        return this.getEntityManager().createNamedQuery("KFOQSDB.getUnique").setParameter("vsnr", (Object)vsnr).setParameter("vpnr", (Object)vpnr).setParameter("abrTraeger", (Object)abrTraeger).setParameter("leistungsart", (Object)leistungsart.getLeistungsartCode()).getResultList();
    }

    @Override
    public long countQsByKey(String vsnr, String vpnr, String abrTraeger, LeistungsartEnum leistungsart) {
        return ((BigInteger)this.getEntityManager().createNamedQuery("KFOQSDB.countUnique").setParameter("vsnr", (Object)vsnr).setParameter("vpnr", (Object)vpnr).setParameter("abrTraeger", (Object)abrTraeger).setParameter("leistungsart", (Object)leistungsart.getLeistungsartCode()).getSingleResult()).longValue();
    }

    @Override
    public void detachEntity(Object o) {
        this.getEntityManager().detach(o);
    }

    @Override
    public List<QsEintrag> getQsForSearch(List<Criterion> criterions, List<Order> orders) {
        Criteria criteria = this.buildBaseCriteria(QsEintrag.class, criterions, orders);
        criteria.createAlias("partner", "partner");
        return criteria.list();
    }
}

