/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.data.entities;

import at.itsv.kfoqsdb.data.entities.Partner;
import at.itsv.kfoqsdb.data.entities.leistungsart.HauptBenhandlung;
import at.itsv.kfoqsdb.data.entities.leistungsart.InterzeptiveBehandlung;
import at.itsv.kfoqsdb.data.entities.validation.QsAndAbrCarrierEquals;
import at.itsv.kfoqsdb.data.entities.validation.TraegerCode;
import at.itsv.kfoqsdb.data.entities.validation.VsnrAndBtnr;
import at.itsv.kfoqsdb.data.entities.validation.marker.QsCreation;
import at.itsv.kfoqsdb.data.entities.validation.marker.QsFinish;
import at.itsv.kfoqsdb.data.entities.validation.marker.QsHistorical;
import at.itsv.kfoqsdb.data.entities.validation.marker.Storno;
import at.itsv.kfoqsdb.internal.enums.IOTNLEEnum;
import at.itsv.kfoqsdb.internal.enums.IOTNQSEnum;
import at.itsv.kfoqsdb.internal.enums.LeistungsartEnum;
import at.itsv.kfoqsdb.internal.enums.PartnerArtEnum;
import at.itsv.kfoqsdb.internal.enums.StatusEnum;
import at.itsv.kfoqsdb.internal.enums.StornogrundEnum;
import at.itsv.tools.model.AbstractEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="\"QsEintrag\"", schema="kfoqsdb")
@NamedNativeQueries(value={@NamedNativeQuery(name="KFOQSDB.findAllEntrieCount", query="SELECT COUNT(q) FROM QsEintrag q"), @NamedNativeQuery(name="KFOQSDB.countUnique", query="SELECT count(q) FROM \"QsEintrag\" q WHERE q.\"VsNr\" = :vsnr AND q.\"VpNr\" = :vpnr AND q.\"ABRTraeger\" = :abrTraeger AND q.\"Leistungsart\" = :leistungsart AND q.\"StornoDatum\" IS NULL"), @NamedNativeQuery(resultClass=QsEintrag.class, name="KFOQSDB.getUnique", query="SELECT * FROM \"QsEintrag\" q WHERE q.\"VsNr\" = :vsnr AND q.\"VpNr\" = :vpnr AND q.\"ABRTraeger\" = :abrTraeger AND q.\"Leistungsart\" = :leistungsart AND q.\"StornoDatum\" IS NULL"), @NamedNativeQuery(resultClass=QsEintrag.class, name="KFOQSDB.getDoublet", query="SELECT *, count(*) FROM \"QsEintrag\" WHERE \"StornoDatum\" IS NULL AND \"qsTraeger\" = :qstraeger GROUP BY \"Leistungsart\", \"VpNr\" , \"VsNr\", \"ABRTraeger\" HAVING count(*) > 1;")})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="\"Leistungsart\"", discriminatorType=DiscriminatorType.STRING)
@VsnrAndBtnr(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
@QsAndAbrCarrierEquals(groups={QsCreation.class, QsFinish.class, QsHistorical.class})
public class QsEintrag
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="kfoqsdb_seq_gen")
    @SequenceGenerator(name="kfoqsdb_seq_gen", sequenceName="kfoqsdb_seq", initialValue=1, allocationSize=1)
    @Column(name="\"ID\"", insertable=false, updatable=false, nullable=false)
    private Long id;
    @Column(name="\"Status\"")
    @Type(type="at.itsv.kfoqsdb.internal.enums.EnumStringType", parameters={@Parameter(name="enumClassName", value="at.itsv.kfoqsdb.internal.enums.StatusEnum"), @Parameter(name="recreateEnumMthd", value="recreateEnum"), @Parameter(name="recreateStringMthd", value="recreateString")})
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private StatusEnum status;
    @Column(name="\"Erstelldatum\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private Date erstelldatum = new Date();
    @Column(name="\"Ersteller\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private String ersteller;
    @Column(name="\"Fachgebiet\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private Integer fachgebiet;
    @Column(name="\"GeprueftInSanktionsverfahren\"")
    private Boolean geprueftInSanktionsverfahren;
    @Column(name="\"IOTNDatumLE\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private Date iotnDatumLE;
    @Column(name="\"IOTNDatumQS\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private Date iotnDatumQS;
    @Column(name="\"IOTNLE\"")
    @Type(type="at.itsv.kfoqsdb.internal.enums.EnumStringType", parameters={@Parameter(name="enumClassName", value="at.itsv.kfoqsdb.internal.enums.IOTNLEEnum"), @Parameter(name="recreateEnumMthd", value="recreateEnum"), @Parameter(name="recreateStringMthd", value="recreateString")})
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private IOTNLEEnum iotnLe;
    @Column(name="\"IOTNQS\"")
    @Type(type="at.itsv.kfoqsdb.internal.enums.EnumStringType", parameters={@Parameter(name="enumClassName", value="at.itsv.kfoqsdb.internal.enums.IOTNQSEnum"), @Parameter(name="recreateEnumMthd", value="recreateEnum"), @Parameter(name="recreateStringMthd", value="recreateString")})
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private IOTNQSEnum iotnQs;
    @NotBlank(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @TraegerCode(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @Column(name="\"LZTraeger\"")
    private String lzTraeger;
    @NotBlank(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @TraegerCode(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @Column(name="\"QSTraeger\"")
    private String qsTraeger;
    @Column(name="\"Stornogrund\"")
    @Type(type="at.itsv.kfoqsdb.internal.enums.EnumIntType", parameters={@Parameter(name="enumClassName", value="at.itsv.kfoqsdb.internal.enums.StornogrundEnum"), @Parameter(name="recreateEnumMthd", value="recreateEnum"), @Parameter(name="recreateStringMthd", value="recreateString")})
    @NotNull(groups={Storno.class}, message="darf nicht fehlen und muss einem g\u00fcltigen Sotrnogrund entsprechen")
    private StornogrundEnum stornoGrund;
    @Column(name="\"StornoDatum\"")
    @NotNull(groups={Storno.class})
    private Date stornoDatum;
    @Column(name="\"StornoBenutzer\"")
    @NotBlank(groups={Storno.class})
    private String stornoBenutzer;
    @NotBlank(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @TraegerCode(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    @Column(name="\"ABRTraeger\"")
    private String abrTraeger;
    @Column(name="\"VsNr\"")
    @NotBlank(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private String vsnr;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"VpNr\"")
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class})
    private Partner partner;
    @Column(name="\"FileUploadId\"", updatable=false)
    private Long fileUpload;
    @Column(name="\"PartnerArt\"")
    @Type(type="at.itsv.kfoqsdb.internal.enums.EnumStringType", parameters={@Parameter(name="enumClassName", value="at.itsv.kfoqsdb.internal.enums.PartnerArtEnum"), @Parameter(name="recreateEnumMthd", value="recreateEnum"), @Parameter(name="recreateStringMthd", value="recreateString")})
    @NotNull(groups={QsFinish.class, QsCreation.class, QsHistorical.class}, message="darf nicht fehlen und muss einer g\u00fcltigen Partnerart entsprechen")
    private PartnerArtEnum art;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Date getErstelldatum() {
        return this.erstelldatum;
    }

    public void setErstelldatum(Date erstelldatum) {
        this.erstelldatum = erstelldatum;
    }

    public String getErsteller() {
        return this.ersteller;
    }

    public void setErsteller(String ersteller) {
        this.ersteller = ersteller;
    }

    public Integer getFachgebiet() {
        return this.fachgebiet;
    }

    public void setFachgebiet(Integer fachgebiet) {
        this.fachgebiet = fachgebiet;
    }

    public Date getIotnDatumLE() {
        return this.iotnDatumLE;
    }

    public void setIotnDatumLE(Date iotnDatumLE) {
        this.iotnDatumLE = iotnDatumLE;
    }

    public Date getIotnDatumQS() {
        return this.iotnDatumQS;
    }

    public void setIotnDatumQS(Date iotnDatumQS) {
        this.iotnDatumQS = iotnDatumQS;
    }

    public LeistungsartEnum getLeistungsart() {
        if (this instanceof InterzeptiveBehandlung) {
            return LeistungsartEnum.IB;
        }
        if (this instanceof HauptBenhandlung) {
            return LeistungsartEnum.HB;
        }
        return LeistungsartEnum.IF;
    }

    public String getLzTraeger() {
        return this.lzTraeger;
    }

    public void setLzTraeger(String lzTraeger) {
        this.lzTraeger = lzTraeger;
    }

    public String getQsTraeger() {
        return this.qsTraeger;
    }

    public void setQsTraeger(String qsTraeger) {
        this.qsTraeger = qsTraeger;
    }

    public StornogrundEnum getStornoGrund() {
        return this.stornoGrund;
    }

    public void setStornoGrund(StornogrundEnum stornoGrund) {
        this.stornoGrund = stornoGrund;
    }

    public Date getStornoDatum() {
        return this.stornoDatum;
    }

    public void setStornoDatum(Date stornoDatum) {
        this.stornoDatum = stornoDatum;
    }

    public String getStornoBenutzer() {
        return this.stornoBenutzer;
    }

    public void setStornoBenutzer(String stornoBenutzer) {
        this.stornoBenutzer = stornoBenutzer;
    }

    public String getAbrTraeger() {
        return this.abrTraeger;
    }

    public void setAbrTraeger(String abrTraeger) {
        this.abrTraeger = abrTraeger;
    }

    public String getVsnr() {
        return this.vsnr;
    }

    public void setVsnr(String vsnr) {
        this.vsnr = vsnr;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Long getFileUpload() {
        return this.fileUpload;
    }

    public void setFileUpload(Long fileUpload) {
        this.fileUpload = fileUpload;
    }

    public PartnerArtEnum getArt() {
        return this.art;
    }

    public void setArt(PartnerArtEnum art) {
        this.art = art;
    }

    public Boolean getGeprueftInSanktionsverfahren() {
        return this.geprueftInSanktionsverfahren;
    }

    public void setGeprueftInSanktionsverfahren(Boolean geprueftInSanktionsverfahren) {
        this.geprueftInSanktionsverfahren = geprueftInSanktionsverfahren;
    }

    public IOTNLEEnum getIotnLe() {
        return this.iotnLe;
    }

    public void setIotnLe(IOTNLEEnum iotnLe) {
        this.iotnLe = iotnLe;
    }

    public IOTNQSEnum getIotnQs() {
        return this.iotnQs;
    }

    public void setIotnQs(IOTNQSEnum iotnQs) {
        this.iotnQs = iotnQs;
    }
}

