/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.kfoqsdb.model.dao;

import at.itsv.tools.dao.GenericDao;
import at.itsv.tools.model.AbstractEntity;
import java.io.Serializable;
import java.util.List;

public interface AbstractDao<E extends AbstractEntity, I extends Serializable>
extends GenericDao<E, I> {
    public void saveOrUpdate(E var1);

    public List<E> getByCriteria(Class<E> var1, List<Criterion> var2, List<Order> var3);

    public List<E> getByCriteria(Class<E> var1, List<Criterion> var2, List<Order> var3, int var4, int var5);

    public int countByCriteria(Class<E> var1, List<Criterion> var2);

    public static final class Order {
        private final String columnName;
        private final boolean ascending;

        private Order(String columnName, boolean ascending) {
            this.columnName = columnName;
            this.ascending = ascending;
        }

        public static Order asc(String columnName) {
            return new Order(columnName, true);
        }

        public static Order desc(String columnName) {
            return new Order(columnName, false);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }

    public static final class Criterion {
        private final CriterionType criterionType;
        private final String columnName;
        private final Object columnValue;

        private Criterion(CriterionType criterionType, String columnName, Object columnValue) {
            this.criterionType = criterionType;
            this.columnName = columnName;
            this.columnValue = columnValue;
        }

        private Criterion(String columnName, Object columnValue) {
            this(CriterionType.eq, columnName, columnValue);
        }

        public static Criterion eq(String columnName, Object columnValue) {
            return new Criterion(columnName, columnValue);
        }

        public static Criterion like(String columnName, Object columnValue) {
            return new Criterion(CriterionType.like, columnName, columnValue);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Object getColumnValue() {
            return this.columnValue;
        }

        public CriterionType getCriterionType() {
            return this.criterionType;
        }
    }

    public static enum CriterionType {
        eq,
        like;

    }
}

